/*
 * Decompiled with CFR 0.152.
 */
package com.icetech.order.service.impl;

import com.icetech.cloudcenter.api.IBatchDownSendService;
import com.icetech.common.domain.SendRequest;
import com.icetech.common.domain.response.ObjectResponse;
import com.icetech.common.validator.Validator;
import com.icetech.third.service.third.MqPushService;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class BatchDownSendServiceImpl
implements IBatchDownSendService {
    private static final Logger log = LoggerFactory.getLogger(BatchDownSendServiceImpl.class);
    @Autowired
    private MqPushService mqPushService;

    public ObjectResponse execute(List<SendRequest> sendRequestList) {
        for (SendRequest sendRequest : sendRequestList) {
            if (Validator.validate((Object)sendRequest)) continue;
            return ObjectResponse.failed((String)"400");
        }
        Map<Long, List<SendRequest>> parkListMap = sendRequestList.stream().collect(Collectors.groupingBy(SendRequest::getParkId));
        Set<Long> parkSet = parkListMap.keySet();
        for (Long parkId : parkSet) {
            List<SendRequest> sendRequests = parkListMap.get(parkId);
            try {
                this.mqPushService.pushBatchDownSend(parkId, sendRequests);
            }
            catch (Exception e) {
                log.error("\u6279\u91cf\u4e0b\u53d1\u5f02\u5e38, \u53c2\u6570[{}]", sendRequestList, (Object)e);
                return ObjectResponse.failed((String)"\u53d1\u9001mq\u6d88\u606f\u5f02\u5e38");
            }
        }
        return ObjectResponse.success();
    }
}

