/*
 * Decompiled with CFR 0.152.
 */
package com.icetech.order.service.impl;

import cn.hutool.core.bean.BeanUtil;
import com.icetech.basics.domain.entity.park.BasePark;
import com.icetech.basics.service.park.impl.ParkServiceImpl;
import com.icetech.common.domain.Page;
import com.icetech.order.domain.dto.BarrierGateExceptionDTO;
import com.icetech.order.domain.entity.BarrierGateException;
import com.icetech.order.domain.vo.BarrierGateExceptionVO;
import com.icetech.order.service.BarrierGateExceptionService;
import com.icetech.order.service.BarrierGateGroupService;
import com.icetech.oss.OssService;
import com.icetech.park.domain.entity.park.Park;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.commons.collections4.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service
public class BarrierGateGroupServiceImpl
implements BarrierGateGroupService {
    private static final Logger log = LoggerFactory.getLogger(BarrierGateGroupServiceImpl.class);
    @Resource
    private BarrierGateExceptionService barrierGateExceptionService;
    @Resource
    private ParkServiceImpl parkService;
    @Resource
    private OssService ossService;

    @Override
    public Page<BarrierGateExceptionVO> listPage(BarrierGateExceptionDTO queryDTO, List<Long> parkIds) {
        Page<BarrierGateException> pageList = this.barrierGateExceptionService.getPageList(queryDTO, parkIds);
        Page voPage = new Page();
        BeanUtil.copyProperties(pageList, (Object)voPage, (String[])new String[0]);
        if (Objects.nonNull(pageList) && CollectionUtils.isNotEmpty((Collection)pageList.getRows())) {
            Set parkIdSet = pageList.getRows().stream().map(BarrierGateException::getParkId).collect(Collectors.toSet());
            Map parkMap = this.parkService.listByIds(parkIdSet).stream().collect(Collectors.toMap(BasePark::getId, Function.identity()));
            List exceptionVOS = pageList.getRows().stream().map(t -> {
                BasePark basePark;
                BarrierGateExceptionVO vo = new BarrierGateExceptionVO();
                BeanUtil.copyProperties((Object)t, (Object)vo, (String[])new String[0]);
                if (queryDTO.getLoadImage().booleanValue()) {
                    vo.setExceptionImage(this.ossService.getImageUrl(vo.getExceptionImage()));
                    vo.setRecoverImage(this.ossService.getImageUrl(vo.getRecoverImage()));
                }
                if (Objects.nonNull(basePark = (BasePark)parkMap.get(t.getParkId()))) {
                    vo.setParkCode(basePark.getParkCode());
                    vo.setParkName(basePark.getParkName());
                }
                return vo;
            }).collect(Collectors.toList());
            voPage.setRows(exceptionVOS);
        }
        return voPage;
    }

    @Override
    public BarrierGateExceptionVO detail(Long recordId, Long parkId) {
        BarrierGateException barrierGateException = (BarrierGateException)this.barrierGateExceptionService.getById(recordId);
        if (barrierGateException == null) {
            return null;
        }
        if (!Objects.equals(barrierGateException.getParkId(), parkId)) {
            return null;
        }
        BarrierGateExceptionVO vo = new BarrierGateExceptionVO();
        BeanUtil.copyProperties((Object)barrierGateException, (Object)vo, (String[])new String[0]);
        Park basePark = (Park)this.parkService.findByParkId(parkId).getData();
        if (Objects.nonNull(basePark)) {
            vo.setParkCode(basePark.getParkCode());
            vo.setParkName(basePark.getParkName());
        }
        vo.setExceptionImage(this.ossService.getImageUrl(vo.getExceptionImage()));
        return vo;
    }
}

