/*
 * Decompiled with CFR 0.152.
 */
package com.icetech.order.dao;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.update.LambdaUpdateWrapper;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.icetech.cloudcenter.domain.order.update.OrderInfoUpdate;
import com.icetech.common.constants.PlateTypeEnum;
import com.icetech.db.mybatis.base.mapper.SuperMapper;
import com.icetech.order.domain.entity.OrderInfo;
import com.icetech.order.domain.entity.OrderSonInfo;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.apache.ibatis.annotations.Param;
import org.springframework.stereotype.Repository;

@Repository
public interface OrderSonInfoDao
extends SuperMapper<OrderSonInfo> {
    default public OrderSonInfo selectOneByEntity(OrderSonInfo entity) {
        return (OrderSonInfo)this.selectLimitOne((LambdaQueryWrapper)Wrappers.lambdaQuery((Object)entity).orderByDesc(OrderInfo::getEnterTime));
    }

    default public int updateByOrderNum(OrderSonInfo sonInfo) {
        Long id = sonInfo.getId();
        String orderNum = sonInfo.getOrderNum();
        sonInfo.setId(null);
        sonInfo.setOrderNum(null);
        int result = this.update(sonInfo, (Wrapper)Wrappers.lambdaUpdate(OrderSonInfo.class).eq(OrderInfo::getOrderNum, (Object)orderNum));
        sonInfo.setId(id);
        sonInfo.setOrderNum(orderNum);
        return result;
    }

    default public int updateByOrderNumAndRegionId(OrderSonInfo sonInfo) {
        Long id = sonInfo.getId();
        String orderNum = sonInfo.getOrderNum();
        Long regionId = sonInfo.getRegionId();
        if (orderNum == null || regionId == null) {
            return 0;
        }
        sonInfo.setId(null);
        sonInfo.setOrderNum(null);
        sonInfo.setRegionId(null);
        int result = this.update(sonInfo, (Wrapper)((LambdaUpdateWrapper)Wrappers.lambdaUpdate(OrderSonInfo.class).eq(OrderInfo::getOrderNum, (Object)orderNum)).eq(OrderInfo::getRegionId, (Object)regionId));
        sonInfo.setId(id);
        sonInfo.setOrderNum(orderNum);
        sonInfo.setRegionId(regionId);
        return result;
    }

    default public int insertWithPlateNum2(OrderSonInfo orderInfo) {
        orderInfo.setPlateNum2(StringUtils.substring((String)orderInfo.getPlateNum(), (int)1));
        return this.insert(orderInfo);
    }

    default public OrderSonInfo fuzzyInParkPlate(Long parkId, String plateNumPart) {
        return (OrderSonInfo)this.selectLimitOne((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)Wrappers.lambdaQuery(OrderSonInfo.class).eq(OrderInfo::getParkId, (Object)parkId)).eq(OrderInfo::getServiceStatus, (Object)1)).eq(OrderInfo::getPlateNum2, (Object)plateNumPart)).orderByDesc(OrderInfo::getEnterTime));
    }

    default public List<OrderSonInfo> selectListByPlates(OrderSonInfo entity, List<String> plateList) {
        return this.selectList((Wrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)Wrappers.lambdaQuery((Object)entity).eq(OrderInfo::getParkId, (Object)entity.getParkId())).eq(OrderInfo::getServiceStatus, (Object)entity.getServiceStatus())).eq(entity.getType() != null, OrderInfo::getType, (Object)entity.getType())).eq(entity.getRegionId() != null && entity.getRegionId() != 0L, OrderInfo::getRegionId, (Object)entity.getRegionId())).in(OrderInfo::getPlateNum, plateList)).orderByAsc(OrderInfo::getEnterTime));
    }

    public Integer updateStatus(OrderInfoUpdate var1);

    public int setInPark(@Param(value="orderSonId") long var1);

    public int setException(@Param(value="orderNum") String var1, @Param(value="exitTime") Long var2, @Param(value="oddStatus") Integer var3);

    default public OrderSonInfo selectOrderSonInpark(String plateNum, Long parkId) {
        return (OrderSonInfo)this.selectLimitOne((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)Wrappers.lambdaQuery(OrderSonInfo.class).eq(OrderInfo::getParkId, (Object)parkId)).eq(OrderInfo::getServiceStatus, (Object)1)).eq(OrderInfo::getPlateNum, (Object)plateNum)).orderByDesc(OrderInfo::getEnterTime));
    }

    default public int countInParkMonthCardByPlateNums(@Param(value="parkId") Long parkId, @Param(value="plateNums") List<String> plateNums, @Param(value="regionId") Long regionId) {
        return this.selectCount((Wrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)Wrappers.lambdaQuery(OrderSonInfo.class).eq(OrderInfo::getParkId, (Object)parkId)).eq(OrderInfo::getServiceStatus, (Object)1)).eq(OrderInfo::getType, (Object)2)).eq(OrderInfo::getRegionId, (Object)regionId)).in(OrderInfo::getPlateNum, plateNums));
    }

    default public int countExitRecordsFromStartTime(@Param(value="parkId") Long parkId, @Param(value="plateNums") List<String> plateNums, @Param(value="regionId") Long regionId, @Param(value="startTime") Long startTime) {
        return this.selectCount((Wrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)Wrappers.lambdaQuery(OrderSonInfo.class).eq(OrderInfo::getParkId, (Object)parkId)).eq(OrderInfo::getRegionId, (Object)regionId)).in(OrderInfo::getPlateNum, plateNums)).and(query -> {
            LambdaQueryWrapper cfr_ignored_0 = (LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)query.ge(OrderInfo::getExitTime, (Object)startTime)).lt(OrderInfo::getEnterTime, (Object)startTime)).or(query2 -> {
                LambdaQueryWrapper cfr_ignored_0 = (LambdaQueryWrapper)((LambdaQueryWrapper)query2.eq(OrderInfo::getServiceStatus, (Object)1)).eq(OrderInfo::getType, (Object)PlateTypeEnum.\u6708\u5361\u8f66.getType());
            });
        }));
    }

    public List<String> selectInParkMonthCardByPlateNums(@Param(value="parkId") Long var1, @Param(value="plateNums") List<String> var2, @Param(value="regionId") Long var3);
}

