/*
 * Decompiled with CFR 0.152.
 */
package com.icetech.order.dao;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.update.LambdaUpdateWrapper;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.icetech.cloudcenter.domain.order.OrderVO;
import com.icetech.cloudcenter.domain.order.update.OrderInfoUpdate;
import com.icetech.cloudcenter.domain.request.FlowRequest;
import com.icetech.cloudcenter.domain.request.OrderQueryRequest;
import com.icetech.cloudcenter.domain.response.EnexDetailDto;
import com.icetech.cloudcenter.domain.response.EnterMatchDto;
import com.icetech.cloudcenter.domain.response.ParkEnterOrexitNumDto;
import com.icetech.common.domain.response.PageQuery;
import com.icetech.db.mybatis.base.mapper.SuperMapper;
import com.icetech.order.domain.dto.OrderInfoDto;
import com.icetech.order.domain.entity.OrderExitEnterTimeVO;
import com.icetech.order.domain.entity.OrderInfo;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.apache.ibatis.annotations.Param;
import org.springframework.stereotype.Repository;

@Repository
public interface OrderInfoDao
extends SuperMapper<OrderInfo> {
    default public OrderInfo selectByOrderNum(String orderNum) {
        return (OrderInfo)this.selectOne((Wrapper)Wrappers.lambdaQuery(OrderInfo.class).eq(OrderInfo::getOrderNum, (Object)orderNum));
    }

    default public OrderInfo selectLimitOneOrderByEnterDesc(OrderInfo entity) {
        return (OrderInfo)this.selectLimitOne((LambdaQueryWrapper)((LambdaQueryWrapper)Wrappers.lambdaQuery((Object)entity).orderByDesc(OrderInfo::getEnterTime)).orderByDesc(OrderInfo::getId));
    }

    default public OrderInfo selectLimitOneNotOrderByEnterDesc(OrderInfo entity, String orderNum) {
        return (OrderInfo)this.selectLimitOne((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)Wrappers.lambdaQuery((Object)entity).notIn(OrderInfo::getOrderNum, new Object[]{orderNum})).orderByDesc(OrderInfo::getEnterTime)).orderByDesc(OrderInfo::getId));
    }

    default public List<OrderInfo> selectListOrderByEnterDesc(OrderInfo entity) {
        return this.selectList((Wrapper)((LambdaQueryWrapper)Wrappers.lambdaQuery((Object)entity).orderByDesc(OrderInfo::getEnterTime)).orderByDesc(OrderInfo::getId));
    }

    default public OrderInfo selectLimitOneByIdDesc(OrderInfo entity) {
        return (OrderInfo)this.selectLimitOne((LambdaQueryWrapper)((LambdaQueryWrapper)Wrappers.lambdaQuery((Object)entity).orderByDesc(OrderInfo::getEnterTime)).orderByDesc(OrderInfo::getId));
    }

    public List<OrderInfo> selectPageList(PageQuery<OrderInfo> var1);

    default public int updateByOrderNum(OrderInfo orderInfo) {
        Long id = orderInfo.getId();
        String orderNum = orderInfo.getOrderNum();
        orderInfo.setId(null);
        orderInfo.setOrderNum(null);
        int result = this.update(orderInfo, (Wrapper)Wrappers.lambdaUpdate(OrderInfo.class).eq(OrderInfo::getOrderNum, (Object)orderNum));
        orderInfo.setId(id);
        orderInfo.setOrderNum(orderNum);
        return result;
    }

    default public int updateByOrderNumAndRegionId(OrderInfo orderInfo) {
        Long id = orderInfo.getId();
        String orderNum = orderInfo.getOrderNum();
        Long regionId = orderInfo.getRegionId();
        orderInfo.setId(null);
        orderInfo.setOrderNum(null);
        orderInfo.setRegionId(null);
        int result = this.update(orderInfo, (Wrapper)((LambdaUpdateWrapper)Wrappers.lambdaUpdate(OrderInfo.class).eq(OrderInfo::getOrderNum, (Object)orderNum)).eq(OrderInfo::getRegionId, (Object)regionId));
        orderInfo.setId(id);
        orderInfo.setOrderNum(orderNum);
        orderInfo.setRegionId(regionId);
        return result;
    }

    default public int insertWithPlateNum2(OrderInfo orderInfo) {
        orderInfo.setPlateNum2(StringUtils.substring((String)orderInfo.getPlateNum(), (int)1));
        return this.insert(orderInfo);
    }

    default public List<OrderInfo> selectListByPlates(OrderInfo entity, List<String> plateList) {
        return this.selectList((Wrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)Wrappers.lambdaQuery((Object)entity).eq(OrderInfo::getParkId, (Object)entity.getParkId())).eq(OrderInfo::getServiceStatus, (Object)entity.getServiceStatus())).eq(entity.getType() != null, OrderInfo::getType, (Object)entity.getType())).eq(entity.getRegionId() != null && entity.getRegionId() != 0L, OrderInfo::getRegionId, (Object)entity.getRegionId())).in(OrderInfo::getPlateNum, plateList)).orderByAsc(OrderInfo::getEnterTime));
    }

    default public List<OrderInfo> selectListByPlates(OrderInfo entity, List<Long> parkIds, List<String> plateList) {
        return this.selectList((Wrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)Wrappers.lambdaQuery((Object)entity).in(OrderInfo::getParkId, parkIds)).eq(OrderInfo::getServiceStatus, (Object)entity.getServiceStatus())).eq(entity.getType() != null, OrderInfo::getType, (Object)entity.getType())).eq(entity.getRegionId() != null && entity.getRegionId() != 0L, OrderInfo::getRegionId, (Object)entity.getRegionId())).in(OrderInfo::getPlateNum, plateList)).orderByAsc(OrderInfo::getEnterTime));
    }

    public List<OrderInfo> selectMadeOrders(@Param(value="parkId") String var1, @Param(value="startTime") String var2);

    public String selectMadeNum(@Param(value="orderNum") String var1);

    public Integer countEnterRecords(@Param(value="parkId") String var1, @Param(value="startTime") Long var2, @Param(value="endTime") Long var3, @Param(value="plateNumber") String var4, @Param(value="type") List<Integer> var5, @Param(value="reliability") Integer var6);

    public Integer countExitRecords(@Param(value="parkId") String var1, @Param(value="startTime") Long var2, @Param(value="endTime") Long var3, @Param(value="plateNumber") String var4, @Param(value="type") List<Integer> var5, @Param(value="enterStartTime") Long var6, @Param(value="enterEndTime") Long var7, @Param(value="tagIds") List<Integer> var8);

    public Integer countExitRecordsFromStartTime(@Param(value="parkId") Long var1, @Param(value="startTime") Long var2, @Param(value="plateNumList") List<String> var3);

    public Integer updateStatus(OrderInfoUpdate var1);

    public List<OrderInfo> selectEnterRecords(@Param(value="parkId") String var1, @Param(value="startTime") Long var2, @Param(value="endTime") Long var3, @Param(value="plateNumber") String var4, @Param(value="type") List<Integer> var5, @Param(value="reliability") Integer var6, @Param(value="tagIds") List<Integer> var7, @Param(value="channelCodes") List<String> var8);

    public List<OrderInfo> selectExitRecords(@Param(value="parkId") String var1, @Param(value="startTime") Long var2, @Param(value="endTime") Long var3, @Param(value="plateNumber") String var4, @Param(value="type") List<Integer> var5, @Param(value="enterStartTime") Long var6, @Param(value="enterEndTime") Long var7, @Param(value="noplateFee") Integer var8, @Param(value="orderNum") String var9, @Param(value="tagIds") List<Integer> var10, @Param(value="freeFlag") Integer var11, @Param(value="channelCodes") List<String> var12, @Param(value="plateNums") List<String> var13);

    public List<OrderInfo> countParkingTime(@Param(value="parkId") String var1, @Param(value="startTime") Long var2, @Param(value="endTime") Long var3);

    public List<OrderExitEnterTimeVO> parkingTimeStatistics(@Param(value="startTime") Long var1, @Param(value="endTime") Long var2, @Param(value="parkId") Long var3);

    public OrderInfo fuzzyOrderByPlate(@Param(value="parkId") long var1, @Param(value="plateNumPart") String var3, @Param(value="status") int var4);

    public OrderInfo fuzzyInParkPlate(@Param(value="parkId") Long var1, @Param(value="plateNums") List<String> var2);

    public OrderInfo fuzzyInParkPlate2(@Param(value="parkId") Long var1, @Param(value="plateNumPart") String var2);

    public OrderInfo fuzzyOutParkPlate(@Param(value="parkId") Long var1, @Param(value="plateNumPart") String var2);

    public List<EnterMatchDto> selectEnterMatchList(@Param(value="parkId") Long var1, @Param(value="startTime") Long var2, @Param(value="endTime") Long var3, @Param(value="plateNumber") String var4, @Param(value="isNoPalte") Boolean var5);

    public List<EnterMatchDto> selectEnterMatchListNew(@Param(value="parkId") Long var1, @Param(value="startTime") Long var2, @Param(value="endTime") Long var3, @Param(value="plateNumber") String var4, @Param(value="isNoPalte") Boolean var5, @Param(value="plateNums") List<String> var6);

    public List<OrderInfo> selectListByParam(@Param(value="parkId") Long var1, @Param(value="startTime") Long var2, @Param(value="endTime") Long var3, @Param(value="plateNumber") String var4);

    public Integer countEnterCar(Long var1);

    public long enterCount(FlowRequest var1);

    public long enterInparkCount(FlowRequest var1);

    public long exitCount(FlowRequest var1);

    public List<EnexDetailDto> enterDetail(FlowRequest var1);

    public List<EnexDetailDto> exitDetail(FlowRequest var1);

    public List<ParkEnterOrexitNumDto> countHoursEnterNum(@Param(value="fromTime") long var1, @Param(value="toTime") long var3);

    public List<ParkEnterOrexitNumDto> countHoursExitNum(@Param(value="fromTime") long var1, @Param(value="toTime") long var3);

    public int countInParkMonthCardByPlateNums(@Param(value="parkId") Long var1, @Param(value="plateNums") List<String> var2);

    public int countInMoreParkMonthCardByPlateNums(@Param(value="parkIds") List<Long> var1, @Param(value="plateNums") List<String> var2);

    public int countMultipleAreaInParkByPlateNums(@Param(value="parkId") Long var1, @Param(value="plateNums") List<String> var2, @Param(value="regionId") Long var3);

    public int countMultipleAreaExitRecordsFromStartTime(@Param(value="parkId") Long var1, @Param(value="plateNums") List<String> var2, @Param(value="regionId") Long var3, @Param(value="startTime") Long var4);

    public int batchExitOrder(@Param(value="orderInfos") List<OrderInfo> var1);

    public Integer findTheMaxIdByDate(@Param(value="parkId") Long var1, @Param(value="startTime") String var2, @Param(value="endTime") String var3);

    public Integer countRecentExitByEnterTime(@Param(value="parkId") Long var1, @Param(value="plateNum") String var2, @Param(value="startTime") Long var3, @Param(value="endTime") Long var4);

    public int countEnexTimesByEnterTime(@Param(value="parkId") Long var1, @Param(value="plateNum") String var2, @Param(value="startTime") Long var3, @Param(value="endTime") Long var4);

    public int selectSurplusCount(@Param(value="parkId") Long var1, @Param(value="createTime") String var2);

    public List<OrderVO> selectSurplusList(@Param(value="parkId") Long var1, @Param(value="createTime") String var2);

    public OrderInfo selectWithHistoryByOrderNum(@Param(value="tables") List<String> var1, @Param(value="orderNum") String var2);

    public OrderInfo fuzzyRecentHistoryOrder(@Param(value="tables") List<String> var1, @Param(value="parkId") Long var2, @Param(value="plateNums") List<String> var3);

    public OrderInfo fuzzyByPlateNums(@Param(value="parkId") Long var1, @Param(value="plateNums") List<String> var2);

    public List<OrderInfo> selectExitOrderBy(@Param(value="parkId") Long var1, @Param(value="startTime") Long var2, @Param(value="endTime") Long var3);

    public List<OrderInfo> selectWithHistoryByOrderNumList(@Param(value="tables") List<String> var1, @Param(value="orderNums") List<String> var2);

    public OrderInfo selectByLocalOrderNumWithHistory(@Param(value="parkId") Long var1, @Param(value="tables") List<String> var2, @Param(value="localOrderNum") String var3);

    public int updateHistoryTable(@Param(value="tableName") String var1, @Param(value="orderInfo") OrderInfo var2);

    public Integer selectChargeLiveCount(@Param(value="parkId") Long var1);

    public Integer selectOilLiveCount(@Param(value="parkId") Long var1);

    public List<String> selectLivePlateNum(@Param(value="parkId") Long var1, @Param(value="limitNum") Integer var2);

    public List<OrderInfoDto> selectMpOrderInfos(OrderQueryRequest var1);
}

