package com.icetech.order.service.impl;

import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.icetech.common.domain.Page;
import com.icetech.db.mybatis.base.service.impl.BaseServiceImpl;
import com.icetech.order.dao.ShamPlateMapper;
import com.icetech.order.service.ShamPlateService;
import com.icetech.park.domain.entity.ShamPlate;
import com.icetech.third.service.third.MqPushService;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.List;
import java.util.Objects;

/**
 * 虚假车牌记录表 服务实现类
 *
 * Copyright (c) Department of Research and Development/Beijing
 * All Rights Reserved
 *
 * @author fangct
 * @version 1.0 @date 2023-07-20
 */
@Service
public class ShamPlateServiceImpl extends BaseServiceImpl<ShamPlateMapper, ShamPlate> implements ShamPlateService {
    @Autowired
    private MqPushService mqPushService;

    /**
     * Description: 根据ID查询 虚假车牌记录表对象信息 <br>
     * Version1.0 2023-07-20 by fangct创建
     *
     * @param id 对象id
     * @return ShamPlate
     */
    @Override
    public ShamPlate getShamPlateById (Long id) {
        return getById(id);
    }

    /**
     * Description: 新增  虚假车牌记录表对象信息 <br>
     * Version1.0 2023-07-20 by fangct创建
     *
     * @param entity 对象信息
     * @return Boolean 返回新增后主键
     */
    @Override
    public Boolean addShamPlate (ShamPlate entity) {
        boolean result = save(entity);
        mqPushService.pushShamPlate(entity);
        return result;
    }

    /**
     * Description: 修改 虚假车牌记录表对象信息 <br>
     * Version1.0 2023-07-20 by fangct创建
     *
     * @param entity 对象信息
     * @return Boolean 返回更新后的结果
     */
    @Override
    public Boolean modifyShamPlate (ShamPlate entity) {
        return updateById(entity);
    }

    /**
     * Description: 删除  虚假车牌记录表对象信息 <br>
     * Version1.0 2023-07-20 by fangct创建
     *
     * @param id 对象id
     * @return Boolean 返回更新后的结果
     */
    @Override
    public Boolean removeShamPlateById (Long id) {
        return removeById(id);
    }

    @Override
    public Page<ShamPlate> getPage(Integer pageNo, Integer pageSize, String plateNum, List<Long> parkIds, String startTime, String endTime) {
        IPage<ShamPlate> page = new com.baomidou.mybatisplus.extension.plugins.pagination.Page<>();
        page.setCurrent(pageNo);
        page.setSize(pageSize);
        LambdaQueryWrapper<ShamPlate> queryWrapper = Wrappers.lambdaQuery(ShamPlate.class);
        if (CollectionUtils.isNotEmpty(parkIds) && !parkIds.contains(-1L)) {
            queryWrapper.in(ShamPlate::getParkId, parkIds);
        }
        if (StringUtils.isNotBlank(plateNum)) {
            queryWrapper.like(ShamPlate::getPlateNum, plateNum);
        }
        if (StringUtils.isNotBlank(startTime)) {
            queryWrapper.ge(ShamPlate::getAlarmTime, startTime);
        }
        if (StringUtils.isNotBlank(endTime)) {
            queryWrapper.le(ShamPlate::getAlarmTime, endTime);
        }
        queryWrapper.orderByDesc(ShamPlate::getId);
        IPage<ShamPlate> result = page(page, queryWrapper);
        return com.icetech.common.domain.Page.instance(Math.toIntExact(result.getPages()), result.getTotal(), result.getRecords());
    }

    @Override
    public Long getTotal(String plateNum, List<Long> parkIds, String startTime, String endTime) {
        LambdaQueryWrapper<ShamPlate> queryWrapper = Wrappers.lambdaQuery(ShamPlate.class);
        if (CollectionUtils.isNotEmpty(parkIds) && !parkIds.contains(-1L)) {
            queryWrapper.in(ShamPlate::getParkId, parkIds);
        }
        if (StringUtils.isNotBlank(plateNum)) {
            queryWrapper.like(ShamPlate::getPlateNum, plateNum);
        }
        if (StringUtils.isNotBlank(startTime)) {
            queryWrapper.ge(ShamPlate::getAlarmTime, startTime);
        }
        if (StringUtils.isNotBlank(endTime)) {
            queryWrapper.le(ShamPlate::getAlarmTime, endTime);
        }
        return Long.valueOf(count(queryWrapper));
    }

    @Override
    public ShamPlate getShamPlateBy(Long id, String orderNum) {
        if (Objects.isNull(id) && StringUtils.isEmpty(orderNum)) {
            return null;
        }
        LambdaQueryWrapper<ShamPlate> queryWrapper = Wrappers.lambdaQuery(ShamPlate.class);
        if (Objects.nonNull(id)) {
            queryWrapper.eq(ShamPlate::getId, id);
        }
        if (StringUtils.isNotEmpty(orderNum)) {
            queryWrapper.eq(ShamPlate::getOrderNum, orderNum);
        }
        return selectLimitOne(queryWrapper);
    }

    @Override
    public List<ShamPlate> getShamPlateListByOrderNum(String orderNum) {
        return list(Wrappers.lambdaQuery(ShamPlate.class).eq(ShamPlate::getOrderNum, orderNum));
    }

}
