package com.icetech.order.service.impl;

import com.baomidou.mybatisplus.core.conditions.update.LambdaUpdateWrapper;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.icetech.cloudcenter.api.order.OrderSonInfoService;
import com.icetech.order.dao.OrderSonInfoDao;
import com.icetech.order.domain.entity.OrderSonInfo;
import com.icetech.db.mybatis.base.service.impl.BaseServiceImpl;
import org.springframework.stereotype.Service;

import java.util.List;

@Service("orderSonInfoService")
public class OrderSonInfoServiceImpl extends BaseServiceImpl<OrderSonInfoDao, OrderSonInfo> implements OrderSonInfoService {
    @Override
    public List<OrderSonInfo> getInfosByOrderNum(Long parkId, String orderNum) {
        return list(getLambdaQueryWrapper().eq(OrderSonInfo::getParkId, parkId).eq(OrderSonInfo::getOrderNum, orderNum));
    }

    @Override
    public boolean updateServiceStatusByOrderNums(List<String> orderNums, Integer serviceStatus) {
        LambdaUpdateWrapper<OrderSonInfo> updateWrapper = Wrappers.lambdaUpdate(entityClass).in(OrderSonInfo::getOrderNum, orderNums).set(true, OrderSonInfo::getServiceStatus, serviceStatus);
        return update(updateWrapper);
    }
}
