package com.icetech.order.service.impl;

import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.icetech.common.domain.Page;
import com.icetech.db.mybatis.base.service.impl.BaseServiceImpl;
import com.icetech.order.dao.OrderNotpaySubaccountMapper;
import com.icetech.order.domain.dto.NotPayAccountQueryDTO;
import com.icetech.order.domain.entity.OrderNotpaySubaccount;
import com.icetech.order.service.OrderNotpaySubaccountService;
import org.apache.commons.collections4.CollectionUtils;
import org.springframework.stereotype.Service;

import java.math.BigDecimal;
import java.util.List;
import java.util.Objects;

/**
 * 欠费追缴费用分账明细 服务实现类
 * <p>
 * Copyright (c) Department of Research and Development/Beijing
 * All Rights Reserved
 *
 * @author fangct
 * @version 1.0 @date 2023-11-07
 */
@Service
public class OrderNotpaySubaccountServiceImpl extends BaseServiceImpl<OrderNotpaySubaccountMapper, OrderNotpaySubaccount> implements OrderNotpaySubaccountService {

    /**
     * Description: 根据ID查询 欠费追缴费用分账明细对象信息 <br>
     * Version1.0 2023-11-07 by fangct创建
     *
     * @param id 对象id
     * @return OrderNotpaySubaccount
     */
    @Override
    public OrderNotpaySubaccount getOrderNotpaySubaccountById(Long id) {
        return getById(id);
    }

    /**
     * Description: 新增  欠费追缴费用分账明细对象信息 <br>
     * Version1.0 2023-11-07 by fangct创建
     *
     * @param entity 对象信息
     * @return Boolean 返回新增后主键
     */
    @Override
    public Boolean addOrderNotpaySubaccount(OrderNotpaySubaccount entity) {
        return save(entity);
    }

    /**
     * Description: 修改 欠费追缴费用分账明细对象信息 <br>
     * Version1.0 2023-11-07 by fangct创建
     *
     * @param entity 对象信息
     * @return Boolean 返回更新后的结果
     */
    @Override
    public Boolean modifyOrderNotpaySubaccount(OrderNotpaySubaccount entity) {
        return updateById(entity);
    }

    /**
     * Description: 删除  欠费追缴费用分账明细对象信息 <br>
     * Version1.0 2023-11-07 by fangct创建
     *
     * @param id 对象id
     * @return Boolean 返回更新后的结果
     */
    @Override
    public Boolean removeOrderNotpaySubaccountById(Long id) {
        return removeById(id);
    }

    @Override
    public Page<OrderNotpaySubaccount> getNotPaySubAccountPage(NotPayAccountQueryDTO queryDTO) {
        IPage<OrderNotpaySubaccount> page = new com.baomidou.mybatisplus.extension.plugins.pagination.Page<>();
        page.setCurrent(queryDTO.getPageNo());
        page.setSize(queryDTO.getPageSize());
        LambdaQueryWrapper<OrderNotpaySubaccount> queryWrapper = Wrappers.lambdaQuery(OrderNotpaySubaccount.class);
        List<Long> parkIds = queryDTO.getParkIds();
        if (CollectionUtils.isNotEmpty(parkIds) && !parkIds.contains(-1L)) {
            queryWrapper.in(OrderNotpaySubaccount::getParkId, parkIds);
        }
        if (Objects.nonNull(queryDTO.getPayStartTime())) {
            queryWrapper.ge(OrderNotpaySubaccount::getPayTime, queryDTO.getPayStartTime());
        }
        if (Objects.nonNull(queryDTO.getPayEndTime())) {
            queryWrapper.le(OrderNotpaySubaccount::getPayTime, queryDTO.getPayEndTime());
        }
        queryWrapper.eq(OrderNotpaySubaccount::getDelFlag, 0);
        queryWrapper.orderByDesc(OrderNotpaySubaccount::getPayTime);
        IPage<OrderNotpaySubaccount> result = page(page, queryWrapper);
        return com.icetech.common.domain.Page.instance(Math.toIntExact(result.getPages()), result.getTotal(), result.getRecords());
    }

    @Override
    public OrderNotpaySubaccount totalMoney(NotPayAccountQueryDTO queryDTO) {
        LambdaQueryWrapper<OrderNotpaySubaccount> queryWrapper = Wrappers.lambdaQuery(OrderNotpaySubaccount.class);
        List<Long> parkIds = queryDTO.getParkIds();
        if (CollectionUtils.isNotEmpty(parkIds) && !parkIds.contains(-1L)) {
            queryWrapper.in(OrderNotpaySubaccount::getParkId, parkIds);
        }
        if (Objects.nonNull(queryDTO.getPayStartTime())) {
            queryWrapper.ge(OrderNotpaySubaccount::getPayTime, queryDTO.getPayStartTime());
        }
        if (Objects.nonNull(queryDTO.getPayEndTime())) {
            queryWrapper.le(OrderNotpaySubaccount::getPayTime, queryDTO.getPayEndTime());
        }
        queryWrapper.eq(OrderNotpaySubaccount::getDelFlag, 0);
        queryWrapper.select(OrderNotpaySubaccount::getPaidPrice, OrderNotpaySubaccount::getPlatformAmount);
        OrderNotpaySubaccount subAccount = new OrderNotpaySubaccount();
        List<OrderNotpaySubaccount> recordList = list(queryWrapper);
        if (CollectionUtils.isNotEmpty(recordList)) {
            subAccount.setPaidPrice(recordList.stream()
                    .map(OrderNotpaySubaccount::getPaidPrice)
                    .filter(Objects::nonNull)
                    .reduce(BigDecimal.ZERO, BigDecimal::add));
            subAccount.setPlatformAmount(recordList.stream()
                    .map(OrderNotpaySubaccount::getPlatformAmount)
                    .filter(Objects::nonNull)
                    .reduce(BigDecimal.ZERO, BigDecimal::add));
        }
        return subAccount;
    }

}
