package com.icetech.order.service.impl;

import cn.hutool.core.date.BetweenFormatter;
import cn.hutool.core.date.DateUtil;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.icetech.basics.domain.entity.device.ParkDevice;
import com.icetech.basics.domain.entity.park.BasePark;
import com.icetech.basics.domain.entity.park.ParkInoutdevice;
import com.icetech.basics.service.park.impl.ParkServiceImpl;
import com.icetech.cloudcenter.api.order.OrderCarInfoService;
import com.icetech.cloudcenter.api.order.OrderService;
import com.icetech.cloudcenter.api.park.ParkDeviceService;
import com.icetech.common.domain.Page;
import com.icetech.common.domain.response.ObjectResponse;
import com.icetech.common.utils.NumberUtils;
import com.icetech.common.utils.StringUtils;
import com.icetech.order.domain.dto.NotPayRecordQueryDTO;
import com.icetech.order.domain.entity.OrderCarInfo;
import com.icetech.order.domain.entity.OrderInfo;
import com.icetech.order.domain.entity.OrderNotpay;
import com.icetech.order.domain.vo.CountVO;
import com.icetech.order.domain.vo.NotPayPage;
import com.icetech.order.domain.vo.OrderNotpayVO;
import com.icetech.order.service.OrderNotpayGroupService;
import com.icetech.order.service.OrderNotpayService;
import com.icetech.oss.OssService;
import com.icetech.park.domain.entity.park.Park;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.collections4.MapUtils;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;

/**
 * @description: TODO
 * @auth: wangzhiwei
 * @date: 2023-07-28  10:26
 * @Version: 1.0
 */
@Service
@Slf4j
public class OrderNotpayGroupServiceImpl implements OrderNotpayGroupService {


    @Autowired
    private OrderNotpayService orderNotpayService;
    @Autowired
    private ParkServiceImpl parkService;
    @Autowired
    private OrderCarInfoService orderCarInfoService;
    @Autowired
    private OrderService orderService;
    @Autowired
    private OssService ossService;
    @Autowired
    private ParkDeviceService parkDeviceService;

    @Override
    public Page<OrderNotpayVO> listPage(NotPayRecordQueryDTO notPayRecordQueryDTO, List<Long> parkIds) {
        Page<OrderNotpay> notPayRecord = orderNotpayService.getNotPayRecord(notPayRecordQueryDTO, parkIds);
        NotPayPage<OrderNotpayVO> orderNotpayVoNotPayPage = new NotPayPage<>();
        BeanUtils.copyProperties(notPayRecord, orderNotpayVoNotPayPage);
        if (CollectionUtils.isNotEmpty(notPayRecord.getRows())) {
            Set<Long> parkIdSet = notPayRecord.getRows().stream().map(OrderNotpay::getParkId).collect(Collectors.toSet());
            Map<Long, Park> parkMap = parkIdSet.parallelStream().map(t-> parkService.findByParkId(t).getData()).collect(Collectors.toMap(Park::getId,
                    Function.identity(), (a, b) -> a));
            Set<String> orderNums = notPayRecord.getRows().stream().map(OrderNotpay::getOrderNum).collect(Collectors.toSet());
            ObjectResponse<List<OrderCarInfo>> carInfoList = orderCarInfoService.getCarInfoList(orderNums, null);
            Map<String, OrderCarInfo> orderCarInfoMap = carInfoList.getData().stream().collect(Collectors.toMap(OrderCarInfo::getOrderNum,Function.identity()));
            List<OrderInfo> orderInfos = orderService.selectListByOrderNums(orderNums);
            Map<String, OrderInfo> orderInfoMap = orderInfos.stream().collect(Collectors.toMap(OrderInfo::getOrderNum,Function.identity()));
            Long[] channelIds = notPayRecord.getRows().stream().map(OrderNotpay::getChannelId).distinct().toArray(Long[]::new);
            Map<Long, ParkInoutdevice> parkInoutdeviceMap = Maps.newHashMap();
            List<Integer> hasMorCameraChannelIds = new ArrayList<>();
            if (channelIds.length>0){
                List<ParkInoutdevice> data = parkService.getChannelsByIds(channelIds).getData();
                if ( CollectionUtils.isNotEmpty(data)){
                    parkInoutdeviceMap = data.stream().collect(Collectors.toMap(ParkInoutdevice::getId, Function.identity()));
                }
                List<Long> channelIdList = notPayRecord.getRows().stream().filter(op -> op.getEvidenceVideo() == null)
                        .map(OrderNotpay::getChannelId).distinct().collect(Collectors.toList());
                ObjectResponse<List<ParkDevice>> devices = parkDeviceService.getDeviceListByChannelIds(channelIdList, 9);
                if (ObjectResponse.isSuccess(devices) && CollectionUtils.isNotEmpty(devices.getData())) {
                    hasMorCameraChannelIds = devices.getData().stream().map(ParkDevice::getChannelId).collect(Collectors.toList());
                }
            }

            Map<Long, ParkInoutdevice> finalParkInoutdeviceMap = parkInoutdeviceMap;
            List<Integer> finalHasMorCameraChannelIds = hasMorCameraChannelIds;
            List<OrderNotpayVO> orderNotpayVOS = notPayRecord.getRows().stream().map(t -> {
                OrderNotpayVO orderNotpayVo = new OrderNotpayVO();
                BeanUtils.copyProperties(t, orderNotpayVo);
                orderNotpayVo.setEvidenceVideo("");
                if (MapUtils.isNotEmpty(parkMap) && parkMap.containsKey(t.getParkId())) {
                    orderNotpayVo.setParkName(parkMap.get(t.getParkId()).getParkName());
                    orderNotpayVo.setParkCode(parkMap.get(t.getParkId()).getParkCode());
                    orderNotpayVo.setIsInterior(parkMap.get(t.getParkId()).getIsInterior());
                }
                OrderCarInfo orderCarInfo = orderCarInfoMap.get(t.getOrderNum());
                if (Objects.nonNull(orderCarInfo)) {
                    Boolean loadImage = notPayRecordQueryDTO.getLoadImage();
                    if (loadImage){
                        orderNotpayVo.setEnterImg(ossService.getImageUrl(orderCarInfo.getSmallEnterImage()));
                        orderNotpayVo.setExitImg(ossService.getImageUrl(orderCarInfo.getSmallExitImage()));
                    }else {
                        orderNotpayVo.setEnterImg("");
                        orderNotpayVo.setExitImg("");
                    }
                }
                OrderInfo orderInfo = orderInfoMap.get(t.getOrderNum());
                if (Objects.nonNull(orderInfo)){
                    orderNotpayVo.setOrderId(orderInfo.getId());
                    orderNotpayVo.setHasSon(orderInfo.getHasSon());
                }
                if (Objects.nonNull(orderNotpayVo.getEnterTime()) && Objects.nonNull(orderNotpayVo.getExitTime())){
                    Long exitTime = orderNotpayVo.getExitTime();
                    long bet = Math.max(exitTime - orderNotpayVo.getEnterTime(),0)*1000;
                    orderNotpayVo.setParkingTimeStr(DateUtil.formatBetween(bet, BetweenFormatter.Level.SECOND));
                }
                ParkInoutdevice parkInoutdevice = finalParkInoutdeviceMap.get(t.getChannelId());
                if(Objects.nonNull(parkInoutdevice)){
                    orderNotpayVo.setWarnChannelName(parkInoutdevice.getInandoutName());
                }
                if (StringUtils.isNotBlank(t.getEvidenceVideo()) ||
                        (parkInoutdevice != null && finalHasMorCameraChannelIds.contains(parkInoutdevice.getId().intValue()))) {
                    orderNotpayVo.setHasMorCamera(1);
                } else {
                    orderNotpayVo.setHasMorCamera(0);
                }
                return orderNotpayVo;
            }).collect(Collectors.toList());
            orderNotpayVoNotPayPage.setRows(orderNotpayVOS);
        }
        return orderNotpayVoNotPayPage;
    }

    @Override
    public CountVO count(NotPayRecordQueryDTO notPayRecordQueryDTO, List<Long> parkIds) {
        return orderNotpayService.getTotal(notPayRecordQueryDTO, parkIds);
    }



    @Override
    public OrderNotpayVO detail(Long recordId, Long parkId) {
        OrderNotpay orderNotpay = orderNotpayService.getById(recordId);
        if (orderNotpay == null){
            return null;
        }
        if (!Objects.equals(orderNotpay.getParkId(), parkId)) return null;
        OrderNotpayVO orderNotpayVo = new OrderNotpayVO();
        BeanUtils.copyProperties(orderNotpay, orderNotpayVo);
        orderNotpayVo.setEvidenceVideo(ossService.getImageUrl(orderNotpayVo.getEvidenceVideo()));
        Park park = parkService.findByParkId(parkId).getData();
        OrderCarInfo orderCarInfo = orderCarInfoService.getCarInfo(orderNotpay.getOrderNum(), parkId).getData();
        OrderInfo orderInfo = orderService.findByOrderNum(orderNotpay.getOrderNum()).getData();
        if (Objects.nonNull(park)) {
            orderNotpayVo.setParkName(park.getParkName());
            orderNotpayVo.setParkCode(park.getParkCode());
            orderNotpayVo.setIsInterior(park.getIsInterior());
        }

        if (Objects.nonNull(orderCarInfo)) {
            orderNotpayVo.setEnterImg(ossService.getImageUrl(orderCarInfo.getSmallEnterImage()));
            orderNotpayVo.setExitImg(ossService.getImageUrl(orderCarInfo.getSmallExitImage()));
        }
        if (Objects.nonNull(orderInfo)){
            orderNotpayVo.setOrderId(orderInfo.getId());
            orderNotpayVo.setHasSon(orderInfo.getHasSon());
            orderNotpayVo.setOrderId(orderInfo.getId());
            Long exitTime = DateUtil.currentSeconds();
            if (Objects.nonNull(orderInfo.getExitTime())){
                exitTime = orderInfo.getExitTime();
            }
            if (NumberUtils.toPrimitive(orderInfo.getNoneEnterFlag()) == 0){
                long bet = Math.max(exitTime - orderInfo.getEnterTime(),0)*1000;
                orderNotpayVo.setParkingTimeStr(DateUtil.formatBetween(bet, BetweenFormatter.Level.SECOND));
            }
        }
        return orderNotpayVo;
    }
}
