package com.icetech.order.service;

import com.icetech.order.domain.entity.OrderRefundRecord;
import com.icetech.db.mybatis.base.service.IBaseService;

/**
 * 退款记录表 服务类
 *
 * Copyright (c) Department of Research and Development/Beijing
 * All Rights Reserved
 *
 * @author wangzhiwei
 * @version 1.0 @date 2022-04-20
 */
public interface OrderRefundRecordService extends IBaseService<OrderRefundRecord> {

    /**
     * Description: 根据ID查询 退款记录表对象信息 <br>
     * Version1.0 2022-04-20 by wangzhiwei创建
     *
     * @param id 对象id
     * @return OrderRefundRecord
     */
    OrderRefundRecord getOrderRefundRecordById (Long id);

    /**
     * Description: 新增  退款记录表对象信息 <br>
     * Version1.0 2022-04-20 by wangzhiwei创建
     *
     * @param entity 对象信息
     * @return Boolean 返回新增后主键
     */
    Boolean addOrderRefundRecord (OrderRefundRecord entity);

    /**
     * Description: 修改 退款记录表对象信息 <br>
     * Version1.0 2022-04-20 by wangzhiwei创建
     *
     * @param entity 对象信息
     * @return Boolean 返回更新后的结果
     */
    Boolean modifyOrderRefundRecord (OrderRefundRecord entity);

    /**
     * Description: 删除  退款记录表对象信息 <br>
     * Version1.0 2022-04-20 by wangzhiwei创建
     *
     * @param id 对象id
     * @return Boolean 返回更新后的结果
     */
    Boolean removeOrderRefundRecordById (Long id);
}
