package com.icetech.order.service;

import com.icetech.db.mybatis.base.service.IBaseService;
import com.icetech.order.domain.dto.PayDiscountListDTO;
import com.icetech.order.domain.entity.OrderPayDiscount;
import com.icetech.order.domain.vo.OrderPayDiscountPageVo;
import com.icetech.order.domain.vo.PayDiscountListVo;

/**
 * 支付优惠关联表 服务类
 *
 * Copyright (c) Department of Research and Development/Beijing
 * All Rights Reserved
 *
 * @author fangchangtong
 * @version 1.0 @date 2024-06-03
 */
public interface OrderPayDiscountService extends IBaseService<OrderPayDiscount> {

    OrderPayDiscountPageVo<PayDiscountListVo> listPage(PayDiscountListDTO queryDTO);
    /**
     * Description: 根据ID查询 支付优惠关联表对象信息 <br>
     * Version1.0 2024-06-03 by fangchangtong创建
     *
     * @param id 对象id
     * @return OrderPayDiscount
     */
    OrderPayDiscount getOrderPayDiscountById (Long id);

    /**
     * Description: 新增  支付优惠关联表对象信息 <br>
     * Version1.0 2024-06-03 by fangchangtong创建
     *
     * @param entity 对象信息
     * @return Boolean 返回新增后主键
     */
    Boolean addOrderPayDiscount (OrderPayDiscount entity);

    /**
     * Description: 修改 支付优惠关联表对象信息 <br>
     * Version1.0 2024-06-03 by fangchangtong创建
     *
     * @param entity 对象信息
     * @return Boolean 返回更新后的结果
     */
    Boolean modifyOrderPayDiscount (OrderPayDiscount entity);

    /**
     * Description: 删除  支付优惠关联表对象信息 <br>
     * Version1.0 2024-06-03 by fangchangtong创建
     *
     * @param id 对象id
     * @return Boolean 返回更新后的结果
     */
    Boolean removeOrderPayDiscountById (Long id);
}
