package com.icetech.order.service;

import com.icetech.common.domain.Page;
import com.icetech.common.domain.response.ObjectResponse;
import com.icetech.order.domain.dto.OrderBackQueryDTO;
import com.icetech.order.domain.entity.OrderBack;
import com.icetech.order.domain.entity.OrderBackReview;
import com.icetech.order.domain.vo.CountVO;
import com.icetech.order.domain.vo.OrderBackVO;

import java.util.List;

/**
 * @description: TODO
 * @auth: wangzhiwei
 * @date: 2023-07-28  15:04
 * @Version: 1.0
 */
public interface OrderBackGroupService {

    /**
     * 分页列表
     * @param queryDTO
     * @return
     */
    Page<OrderBackVO> listPage(OrderBackQueryDTO queryDTO, List<Long> parkIds);

    /**
     * 仅仅统计
     * @param queryDTO
     * @param parkIds
     * @return
     */
    CountVO count(OrderBackQueryDTO queryDTO, List<Long> parkIds);

    /**
     * 详情
     * @param recordId
     * @param parkId
     * @return
     */
    OrderBackVO detail(Long recordId,Long parkId);

    /**
     * 详情 返回该订单的最后一个
     * @param orderNum
     * @param parkId
     * @return
     */
    OrderBackVO detail(String orderNum,Long parkId);

    /**
     * 获取列表
     * @param orderNum
     * @return
     */
    List<OrderBackVO> listByOrderNum(String orderNum);

    /**
     * 车辆折返审核
     * @param review 入参
     * @return 返回状态
     */
    ObjectResponse<Void> review(OrderBackReview review);
}
