package com.icetech.order.dao;

import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.icetech.cloudcenter.domain.charge.dto.OrderSumFeeDto;
import com.icetech.park.domain.dto.InvoiceParksDto;
import com.icetech.order.domain.entity.OrderPay;
import com.icetech.cloudcenter.domain.order.SumOrderDatePayDto;
import com.icetech.cloudcenter.domain.order.SumOrderMoneyDto;
import com.icetech.cloudcenter.domain.order.SumOrderPayDto;
import com.icetech.cloudcenter.domain.order.SumPayByOrderNumDto;
import com.icetech.cloudcenter.domain.order.query.OrderPayCondition;
import com.icetech.cloudcenter.domain.order.query.OrderPayQuery;
import com.icetech.cloudcenter.domain.request.BossOrderPayRequest;
import com.icetech.cloudcenter.domain.request.FlowRequest;
import com.icetech.cloudcenter.domain.request.ParkIncomeTopRequest;
import com.icetech.cloudcenter.domain.request.PaywayTopRequest;
import com.icetech.cloudcenter.domain.request.SumOrderPayRequest;
import com.icetech.cloudcenter.domain.response.*;
import com.icetech.common.domain.response.PageQuery;

import com.icetech.db.mybatis.base.mapper.SuperMapper;
import com.icetech.report.domain.entity.ParkReportStatics;
import com.icetech.report.domain.entity.PaymentRebateDayReport;
import com.icetech.report.domain.vo.ParkPayReportVo;
import org.apache.ibatis.annotations.Param;
import org.springframework.stereotype.Repository;

import java.math.BigDecimal;
import java.util.Collection;
import java.util.Date;
import java.util.List;

/**
 * Description : 订单出入场记录表操作DAO
 *
 * @author fangct
 */
@Repository
public interface OrderPayDao extends SuperMapper<OrderPay> {
    /**
     * 更新
     *
     * @param model
     * @return
     */
    int updateByEntity(OrderPay model);

    /**
     * 分页查询结果集
     *
     * @param query
     * @return
     */
    List<OrderPay> selectListByPage(PageQuery<OrderPay> query);

    /**
     * 汇总车辆指定时间段收费总额--入场时间
     *
     * @return
     */
    BigDecimal sumPalteOrderPay(@Param("parkId") Long parkId, @Param("plateNum") String plateNum, @Param("payTimeStart") Long payTimeStart, @Param("payTimeEnd") Long payTimeEnd);

    /**
     * 汇总车辆指定时间段收费总额--离场时间
     *
     * @return
     */
    BigDecimal sumPalteOrderPayByExittime(@Param("parkId") Long parkId, @Param("plateNum") String plateNum, @Param("payTimeStart") Long payTimeStart, @Param("payTimeEnd") Long payTimeEnd);

    /**
     * 汇总车辆在场内的预缴费总额
     *
     * @return
     */
    BigDecimal sumPalteProOrderPay(@Param("parkId") Long parkId, @Param("plateNum") String plateNum, @Param("payTimeStart") Long payTimeStart);

    int updateStatus(OrderPayQuery orderPayQuery);

    /**
     * 根据订单号查询
     *
     * @param orderNum
     * @return
     */
    @Deprecated
    OrderPay selectByOrdernum(@Param("orderNum") String orderNum, @Param("payChannel") Integer payChannel);

    List<OrderPay> selectByOrderNum(@Param("orderNum") String orderNum);

    /**
     * 收入汇总
     *
     * @param flowRequest
     * @return
     */
    IncomeCountDto incomeCount(FlowRequest flowRequest);

    /**
     * 收入明细
     *
     * @param flowRequest
     * @return
     */
    List<IncomeDetailDto> incomeDetail(FlowRequest flowRequest);

    /**
     * 按支付方式统计收入
     *
     * @param flowRequest
     * @return
     */
    List<PayWayCountDto> payWayCount(FlowRequest flowRequest);

    /**
     * 获取报表数据-临停支付
     *
     * @return
     */
    List<PayWayCountDto> countReportPay(@Param("parkIdList") String parkIdList, @Param("startTime") String startTime, @Param("endTime") String endTime);

    /**
     * 停车场收入排名
     *
     * @param parkIncomeTopRequest
     * @return
     */
    List<ParkIncomeTopDto> parkIncomeTop(ParkIncomeTopRequest parkIncomeTopRequest);

    /**
     * 支付方式排名
     *
     * @param paywayTopRequest
     * @return
     */
    List<PaywayTopDto> paywayTop(PaywayTopRequest paywayTopRequest);


    /**
     * 按小时统计车场的营收到当前时间
     *
     * @param parkIdList
     * @param todayTime
     * @return
     */
    List<IncomeCountHourDto> countTodayIncome(@Param("parkIdList") String parkIdList, @Param("todayTime") Long todayTime);

    /**
     * 交易明细查询
     *
     * @param parkId
     * @param startTime
     * @param endTime
     * @param plateNumber
     * @param userName
     * @param payChannel
     * @param payType
     * @return
     */
    List<OrderPayDto> selectOrderPayList(@Param("parkId") String parkId, @Param("startTime") Long startTime, @Param("endTime") Long endTime, @Param("plateNumber") String plateNumber,
                                         @Param("payWay") List<Integer> payWay, @Param("userName") String userName, @Param("payChannel") List<Integer> payChannel,
                                         @Param("type") List<Integer> type, @Param("orderNum") String orderNum, @Param("payType") Integer payType);

    /**
     * 临停支付报表
     * @param startTime
     * @param endTime
     * @param parkId
     * @return
     */
    List<OrderPayResultVo> selectPayOrderList(@Param("startTime") String startTime, @Param("endTime") String endTime, @Param("parkId")Long parkId);

    /**
     * 汇总已支付费用
     *
     * @param orderPay
     * @return
     */
    OrderSumFeeDto sumFee(OrderPay orderPay);

    List<OrderSumFeeDto> sumFees(@Param("orderPays") Collection<OrderPay> orderPays);

    /**
     * 按条件查询汇总
     *
     * @param orderPayCondition
     * @return
     */
    OrderSumFeeDto sumPay(OrderPayCondition orderPayCondition);

    /**
     * 查询公众号上的订单记录
     *
     * @param plateNum
     * @param startTime
     * @param endTime
     */
    List<OrderDto> selectMpOrderList(@Param("mpUserId") Integer mpUserId, @Param("plateNum") String plateNum, @Param("startTime") Long startTime, @Param("endTime") Long endTime);

    /**
     * 联合查询临停车缴费 和 月卡续租的账号
     *
     * @param mpUserId
     * @param plateNum
     * @param startTime
     * @param endTime
     * @return
     */
    List<OrderDto> selectMpOrderListByPlateNum(@Param("mpUserId") Integer mpUserId, @Param("plateNum") String plateNum, @Param("startTime") Long startTime, @Param("endTime") Long endTime);
    OrderCountDto countMpOrderByPlateNum(@Param("mpUserId") Integer mpUserId, @Param("plateNum") String plateNum, @Param("startTime") Long startTime, @Param("endTime") Long endTime);

    /**
     * 统计当前班次的现金收费金额
     *
     * @param workOnTime
     * @param recordId
     * @param parkId
     * @param endTime
     * @return
     */
    SumOrderMoneyDto selectMoneyCountByTime(@Param("workOnTime") Date workOnTime, @Param("recordId") Integer recordId, @Param("parkId") Integer parkId, @Param("endTime") String endTime);

    /**
     * 获取多车场的现金结账
     * @param parkIds
     * @param userId
     * @return
     */
    List<SumOrderMoneyDto> getParkListWithMoney(@Param("parkIds") List<Long> parkIds, @Param("userId") Integer userId);

    /**
     * 汇总
     *
     * @param sumOrderPayRequest
     * @return
     */
    SumOrderPayDto sumOrderPay(SumOrderPayRequest sumOrderPayRequest);

    /**
     * 财务报表-收入汇总-非当天
     *
     * @return
     */
    SumOrderPayDto summaryReportPay(@Param("parkIdList") String parkIdList, @Param("startTime") String startTime, @Param("endTime") String endTime);

    /**
     * 汇总-多条件
     *
     * @param bossOrderPayRequest
     * @return
     */
    List<SumOrderDatePayDto> sumOrderPayListCount(BossOrderPayRequest bossOrderPayRequest);

    /**
     * 统计支付条数
     *
     * @param parkId
     * @param startTime
     * @param endTime
     * @param plateNumber
     * @param payWay
     * @param userName
     * @param type
     * @param payChannel
     * @return
     */
    int countOrderPayList(@Param("parkId") String parkId, @Param("startTime") Long startTime, @Param("endTime") Long endTime,
                          @Param("plateNumber") String plateNumber, @Param("payWay") List<Integer> payWay, @Param("userName") String userName,
                          @Param("type") List<Integer> type, @Param("payChannel") List<Integer> payChannel, @Param("payType") Integer payType);

    /**
     * 计算金额
     *
     * @param parkId
     * @param startTime
     * @param endTime
     * @param plateNumber
     * @param payWay
     * @param userName
     * @param type
     * @param payChannel
     * @return
     */
    BigDecimal sumOrderPayList(@Param("parkId") String parkId, @Param("startTime") Long startTime, @Param("endTime") Long endTime,
                               @Param("plateNumber") String plateNumber, @Param("payWay") List<Integer> payWay, @Param("userName") String userName,
                               @Param("type") List<Integer> type, @Param("payChannel") List<Integer> payChannel, @Param("payType") Integer payType);

    /**
     * 根据车牌号获取所有已支付的但未开票的交易记录
     *
     *
     * @param plateNums
     * @param parkId
     * @param startTime
     * @param endTime
     * @return
     */
    List<InvoiceResponse> selectNoInvoiceListByPlateNum(@Param("tables") List<String> tables, @Param("plateNums") List<String> plateNums,@Param("accountId") Long accountId, @Param("parkId") Long parkId, @Param("parkIds") Collection<Long> parkIds, @Param("startTime") Long startTime, @Param("endTime") Long endTime);

    /**
     * 获取所有未开票的车场列表
     *
     * @param tables
     * @param plateNums
     * @param parkIds
     * @param startTime
     * @param endTime
     * @return
     */
    List<InvoiceParksDto> selectNoInvoiceParkListByPlateNum(@Param("tables") List<String> tables, @Param("plateNums") List<String> plateNums, @Param("accountId") Long accountId, @Param("parkId") Long parkId, @Param("parkIds") List<Integer> parkIds, @Param("startTime") Long startTime, @Param("endTime") Long endTime);

    /**
     * 根据交易流水号查询
     *
     * @param tradeNos
     * @return
     */
    List<OrderPay> selectListByTradeNos(@Param("tradeNos") List<String> tradeNos);

    /**
     * 根据交易流水号查询包含历史库的数据
     * @param tradeNos
     * @return
     */
    List<OrderPay> selectListWithHistoryByTradeNos(@Param("tables") List<String> tables, @Param("tradeNos") List<String> tradeNos);

    /**
     * 更新票状态为已开票
     *
     * @param tradeNos
     * @return
     */
    int updateInvoiceStatus(@Param("tradeNos") List<String> tradeNos);

    /**
     * 更新历史表
     * @param table 历史表
     * @param tradeNos 交易流水号列表
     * @return 影响行数
     */
    int updateHistoryInvoiceStatus(@Param("table") String table, @Param("tradeNos") List<String> tradeNos);

    /**
     * 根据车牌号获取所有已支付的但未开票的交易记录
     *
     * @param plateNum
     * @param startTime
     * @param endTime
     * @return
     */
    List<InvoiceQueryResponse> selectInvoiceListByPlateNum(@Param("source") Integer source, @Param("plateNum") String plateNum, @Param("startTime") Long startTime, @Param("endTime") Long endTime, @Param("ticketStatuses") String ticketStatuses);

    /**
     * 通过车场ID和车牌号查询支付记录列表
     *
     * @param parkId
     * @param plateNum
     * @param exitTimeStart
     * @param exitTimeEnd
     * @return
     */
    List<SumPayByOrderNumDto> sumPaidPriceByPlateNum(@Param("parkId") Long parkId, @Param("plateNum") String plateNum, @Param("exitTimeStart") Long exitTimeStart, @Param("exitTimeEnd") Long exitTimeEnd);

    /**
     * 查询orderPay列表
     * @param startTime
     * @param endTime
     * @param parkId
     * @return
     */
    List<OrderPay> getOrderPayList(@Param("startTime") Long startTime, @Param("endTime") Long endTime, @Param("parkId")Long parkId);


    /**
     * 获取临停收入
     *
     * @param parkId
     * @param startTime
     * @param endTime
     * @param payWay
     * @param plateNumber
     * @param payType
     * @return
     */
    BigDecimal selectTempPayAmount(@Param("parkId") Long parkId, @Param("startTime") Long startTime, @Param("endTime") Long endTime,
                                   @Param("payWay") List<Integer> payWay, @Param("plateNumber") String plateNumber, @Param("payType") Integer payType);

    /**
     * 运营分析统计
     *
     * @param startTime 支付开始时间
     * @param endTime 支付结束时间
     * @return
     */
    List<ParkReportStatics> selectParkReportStatics(@Param("startTime") Long startTime, @Param("endTime") Long endTime);

    /**
     * 运营分析统计支付渠道
     *
     * @param startTime 支付开始时间
     * @param endTime 支付结束时间
     * @return
     */
    Integer selectPayAisleCount(@Param("startTime") Long startTime, @Param("endTime") Long endTime);

    /**
     * 获取电子支付明细列表-月
     *
     * @param startTime
     * @param endTime
     * @return
     */
    List<ParkPayReportVo> selectMonthPayList(@Param("startTime") String startTime, @Param("endTime") String endTime);

    /**
     * 获取电子支付明细列表-年
     *
     * @param startTime
     * @param endTime
     * @return
     */
    List<ParkPayReportVo> selectYearPayList(@Param("startTime") String startTime, @Param("endTime") String endTime);



    /**
     * 获取支付返利金额
     *
     * @param reportDate
     * @return
     */
    List<PaymentRebateDayReport> selectPayRebateAmount(@Param("reportDate") String reportDate);

    /**
     * 获取补缴金额
     *
     * @param startTime
     * @param endTime
     * @return
     */
    BigDecimal getSupplementaryPaymentAmount(@Param("startTime") Long startTime, @Param("endTime") Long endTime);

    /**
     *
     * @param tradeNo
     * @return
     */
    default OrderPay selectByTradeNo(String tradeNo){
        return selectLimitOne(Wrappers.lambdaQuery(OrderPay.class).eq(OrderPay::getTradeNo, tradeNo));
    }

    /**
     *
     * @param orderNums
     * @param tradeNo
     * @return
     */
    List<OrderPay> selectListByTradeNoAndOrderNums(List<String> orderNums, String tradeNo);
}
