package com.icetech.order.dao;

import com.icetech.cloudcenter.domain.response.ParkEnterOrexitCountDto;
import com.icetech.cloudcenter.domain.order.query.OrderEnexCount;
import com.icetech.db.dao.BaseDao;
import org.apache.ibatis.annotations.Param;
import org.springframework.stereotype.Repository;

import java.time.LocalDate;
import java.util.Date;
import java.util.List;

/**
 *
 *
 *
 * @author xuxueli
 * @date '2019-02-14 16:22:40'
 */
@Repository
public interface OrderEnexCountDao extends BaseDao<OrderEnexCount> {

    /**
     * 按小时时间段返回进出场车辆统计
     * @param fromTime 24 之前 开始的时间戳
     * @param toTime 截至时间戳
     * @return
     */
    List<ParkEnterOrexitCountDto> countHoursEnterOrExitNum(@Param("parkIdList") String parkIdList, @Param("fromTime") String fromTime, @Param("toTime")String toTime);

    /**
     * 按天时间段返回进出场车辆统计
     * @param fromTime 7/30 之前 开始的时间戳
     * @param toTime 截至时间戳
     * @return
     */
    List<ParkEnterOrexitCountDto> countDaysEnterOrExitNum(@Param("parkIdList") String parkIdList,@Param("fromTime") String fromTime, @Param("toTime")String toTime);

    /**
     * 获取日期
     * @param parkId
     * @param countTime
     * @return
     */
    OrderEnexCount selectByCountTime(@Param("parkId")Long parkId,@Param("countTime") Date countTime);

    /**
     * 获取在现场车数
     *
     * @param countTime 统计时间
     * @return
     */
    Integer selectLiveParkByCountTime(@Param("countTime") String countTime);

    /**
     * 获取指定日期每小时出入数量统计
     * @param parkId 车场ID
     * @param countDate 日期
     * @return {@link ParkEnterOrexitCountDto#getTimeRange()} 为小时时间(0-23)
     */
    List<ParkEnterOrexitCountDto> selectCountsByDate(@Param("parkId") Long parkId, @Param("countDate") LocalDate countDate);
}
