/*
 * Decompiled with CFR 0.152.
 */
package com.icetech.fee.service.storecard.impl;

import com.github.pagehelper.PageHelper;
import com.icetech.cloudcenter.api.store.StoreCardService;
import com.icetech.cloudcenter.domain.enumeration.DownServiceEnum;
import com.icetech.cloudcenter.domain.request.ExitCommonRequest;
import com.icetech.cloudcenter.domain.response.QueryOrderFeeResponse;
import com.icetech.common.constants.CodeConstants;
import com.icetech.common.domain.response.ObjectResponse;
import com.icetech.common.utils.DateTools;
import com.icetech.common.utils.NumberUtils;
import com.icetech.fee.dao.storecard.StoreCardDao;
import com.icetech.fee.dao.storecard.StoreCardPlateDao;
import com.icetech.fee.dao.storecard.StoreCardUsedDao;
import com.icetech.fee.dao.storecard.StoredCardRecordDao;
import com.icetech.fee.domain.entity.storecard.StoreCard;
import com.icetech.fee.domain.entity.storecard.StoreCardPlate;
import com.icetech.fee.domain.entity.storecard.StoreCardRecord;
import com.icetech.fee.domain.entity.storecard.StoreCardUsed;
import com.icetech.order.domain.dto.StoredCardRecordDto;
import com.icetech.order.domain.entity.OrderInfo;
import com.icetech.third.anno.DS_SLAVE;
import com.icetech.third.dao.send.SendinfoDao;
import com.icetech.third.domain.entity.third.SendInfo;
import java.math.BigDecimal;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.List;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service(value="StoreCardService")
public class StoreCardServiceImpl
implements StoreCardService {
    private static final Logger log = LoggerFactory.getLogger(StoreCardServiceImpl.class);
    @Autowired
    private StoreCardDao storeCardDao;
    @Autowired
    private StoreCardPlateDao storeCardPlateDao;
    @Resource
    private StoredCardRecordDao storedCardRecordDao;
    @Resource
    private StoreCardUsedDao storeCardUsedDao;
    @Resource
    private SendinfoDao sendinfoDao;

    public ObjectResponse<StoreCard> getStoreCardDetail(Integer cardId) {
        log.info("getStoreCardDetail======>{}", (Object)cardId);
        if (null == cardId) {
            return ObjectResponse.failed((String)"404");
        }
        StoreCard storeCard = this.storeCardDao.selectByCardId(cardId);
        if (storeCard == null) {
            return ObjectResponse.failed((String)"404", (String)("\u50a8\u503c\u5361[" + cardId + "]\u4fe1\u606f\u4e0d\u5b58\u5728"));
        }
        return ObjectResponse.success((Object)storeCard);
    }

    public ObjectResponse<List<StoreCard>> getStoreCardList(List<StoreCardPlate> storeCardPlateList) {
        log.info("getStoreCardList===========>{}", storeCardPlateList);
        if (null == storeCardPlateList || storeCardPlateList.size() == 0) {
            return ObjectResponse.failed((String)"404");
        }
        List<StoreCard> storeCardList = this.storeCardDao.selectByCardPlates(storeCardPlateList);
        boolean isSuccess = null != storeCardList && storeCardList.size() > 0;
        return new ObjectResponse(isSuccess ? "200" : "404", isSuccess ? CodeConstants.getName((String)"200") : CodeConstants.getName((String)"404"), storeCardList);
    }

    public ObjectResponse<StoreCard> getValidStoreCards(String plate, Long parkId) {
        List storeCardList;
        ObjectResponse<List<StoreCard>> storeCardObjectResponse;
        List storeCardPlate;
        ObjectResponse<List<StoreCardPlate>> objectResponse = this.getStoreCardPlate(plate);
        StoreCard storeCard = null;
        if ("200".equals(objectResponse.getCode()) && null != (storeCardPlate = (List)objectResponse.getData()) && storeCardPlate.size() > 0 && "200".equals((storeCardObjectResponse = this.getStoreCardList(storeCardPlate)).getCode()) && null != (storeCardList = (List)storeCardObjectResponse.getData()) && storeCardList.size() > 0) {
            Date nowDate = new Date();
            for (StoreCard item : storeCardList) {
                if (null == item || null == parkId || !item.getParkId().equals(parkId.intValue())) continue;
                storeCard = item;
            }
            if (null != storeCard && storeCard.getStartTime().getTime() <= nowDate.getTime() && StoreCardServiceImpl.dateCompare(nowDate, storeCard.getEndTime()) < 1) {
                return ObjectResponse.success(storeCard);
            }
        }
        return ObjectResponse.failed((String)"404");
    }

    public ObjectResponse<List<StoreCardPlate>> getStoreCardPlate(String plateNum) {
        if (null == plateNum) {
            return ObjectResponse.failed((String)"404");
        }
        List<StoreCardPlate> storeCardPlates = this.storeCardPlateDao.selectByPlate(plateNum);
        boolean isSuccess = storeCardPlates != null && storeCardPlates.size() > 0;
        ObjectResponse storeCardPlateObjectResponse = new ObjectResponse();
        storeCardPlateObjectResponse.setData(storeCardPlates);
        storeCardPlateObjectResponse.setCode(isSuccess ? "200" : "404");
        storeCardPlateObjectResponse.setMsg(isSuccess ? CodeConstants.getName((String)"200") : CodeConstants.getName((String)"404"));
        return storeCardPlateObjectResponse;
    }

    public ObjectResponse updateStoreCardBalance(StoreCard storeCard) {
        this.storeCardDao.updateBalance(storeCard);
        return ObjectResponse.success();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public ObjectResponse<StoreCard> chargeStoreCard(QueryOrderFeeResponse queryOrderFeeResponse, Long parkId) {
        String plate = queryOrderFeeResponse.getPlateNum();
        ObjectResponse<List<StoreCardPlate>> objectResponse = this.getStoreCardPlate(plate);
        StoreCard storeCard = null;
        if (!"200".equals(objectResponse.getCode())) return ObjectResponse.failed((String)"404");
        List storeCardPlate = (List)objectResponse.getData();
        ObjectResponse<List<StoreCard>> storeCardObjectResponse = this.getStoreCardList(storeCardPlate);
        if (!"200".equals(storeCardObjectResponse.getCode())) return ObjectResponse.failed((String)"404");
        List storeCardList = (List)storeCardObjectResponse.getData();
        for (StoreCard item : storeCardList) {
            if (null == item || !parkId.equals(item.getParkId().longValue())) continue;
            storeCard = item;
        }
        if (null == storeCard) {
            return ObjectResponse.failed((String)"404");
        }
        log.info("\u67e5\u8be2\u50a8\u503c\u5361\u7ed3\u679c\uff1a {}", storeCard);
        Date nowDate = new Date();
        BigDecimal unPay = new BigDecimal(queryOrderFeeResponse.getUnpayPrice());
        BigDecimal oldBalance = storeCard.getBalance();
        BigDecimal needUpdateBalance = oldBalance.subtract(unPay);
        if (storeCard.getStartTime().getTime() > nowDate.getTime() || StoreCardServiceImpl.dateCompare(nowDate, storeCard.getEndTime()) >= 1 || new BigDecimal(0).compareTo(needUpdateBalance) >= 1) {
            return ObjectResponse.failed((String)"404");
        }
        storeCard.setBalance(needUpdateBalance);
        storeCard.setUpdateTime(nowDate);
        this.updateStoreCardBalance(storeCard);
        StoreCardUsed cardUsed = new StoreCardUsed();
        cardUsed.setParkId(parkId);
        cardUsed.setOrderNum(queryOrderFeeResponse.getOrderNum());
        cardUsed.setPlateNum(queryOrderFeeResponse.getPlateNum());
        cardUsed.setEnterTime(queryOrderFeeResponse.getEnterTime());
        cardUsed.setExitTime(Long.valueOf(nowDate.getTime() / 1000L));
        cardUsed.setPayTime(nowDate);
        cardUsed.setTotalPrice(Double.valueOf(queryOrderFeeResponse.getTotalAmount()));
        cardUsed.setDiscountPrice(Double.valueOf(queryOrderFeeResponse.getDiscountAmount()));
        cardUsed.setCardId(Long.valueOf(storeCard.getId().longValue()));
        cardUsed.setCardBeforeAmount(Double.valueOf(oldBalance.doubleValue()));
        cardUsed.setCardDeductAmount(Double.valueOf(unPay.doubleValue()));
        cardUsed.setCardAfterAmount(Double.valueOf(needUpdateBalance.doubleValue()));
        this.storeCardUsedDao.insert(cardUsed);
        return ObjectResponse.success((Object)storeCard);
    }

    @Transactional
    public ObjectResponse<StoreCard> deductStoreCard(ExitCommonRequest request, ExitCommonRequest.PaidInfo paidInfo, OrderInfo orderInfo) {
        Double balancePrice = paidInfo.getBalancePrice();
        StoreCard storeCard = this.storeCardDao.selectValidateCard(request.getParkId(), request.getPlateNum());
        if (storeCard == null) {
            return ObjectResponse.failed((String)"404");
        }
        BigDecimal oldBalance = storeCard.getBalance();
        BigDecimal balance = oldBalance.subtract(BigDecimal.valueOf(balancePrice));
        if (balance.compareTo(BigDecimal.ZERO) < 0) {
            balance = BigDecimal.ZERO;
            log.warn("\u50a8\u503c\u5361[{}][{}][{}]\u4f59\u989d\u4e0d\u8db3", new Object[]{storeCard.getId(), request.getParkId(), request.getPlateNum()});
        }
        storeCard.setBalance(balance);
        Date now = new Date();
        storeCard.setUpdateTime(now);
        this.storeCardDao.updateBalance(storeCard);
        StoreCardUsed cardUsed = new StoreCardUsed();
        cardUsed.setParkId(request.getParkId());
        cardUsed.setOrderNum(orderInfo.getOrderNum());
        cardUsed.setPlateNum(request.getPlateNum());
        cardUsed.setEnterTime(orderInfo.getEnterTime());
        cardUsed.setExitTime(orderInfo.getExitTime());
        cardUsed.setPayTime(new Date(paidInfo.getPayTime() * 1000L));
        cardUsed.setTotalPrice(Double.valueOf(request.getTotalAmount()));
        cardUsed.setDiscountPrice(Double.valueOf(request.getDiscountAmount()));
        cardUsed.setCardId(Long.valueOf(storeCard.getId().longValue()));
        cardUsed.setCardBeforeAmount(Double.valueOf(oldBalance.doubleValue()));
        cardUsed.setCardDeductAmount(balancePrice);
        cardUsed.setCardAfterAmount(Double.valueOf(balance.doubleValue()));
        this.storeCardUsedDao.insert(cardUsed);
        SendInfo sendInfo = new SendInfo();
        sendInfo.setParkId(Long.valueOf(storeCard.getParkId().longValue()));
        sendInfo.setServiceType(DownServiceEnum.\u50a8\u503c\u5361\u8f66\u8f86\u4fe1\u606f.getServiceType());
        sendInfo.setServiceId(cardUsed.getId());
        sendInfo.setInclude("use");
        sendInfo.setLevel(Integer.valueOf(2));
        sendInfo.setNextFireTime(Integer.valueOf((int)DateTools.unixTimestamp()));
        sendInfo.setStatus(Integer.valueOf(0));
        sendInfo.setSendType(Integer.valueOf(0));
        sendInfo.setSendNum(Integer.valueOf(0));
        sendInfo.setTargetService(Integer.valueOf(1));
        sendInfo.setCreateTime(now);
        sendInfo.setUpdateTime(now);
        this.sendinfoDao.insert((Object)sendInfo);
        return ObjectResponse.success((Object)storeCard);
    }

    public ObjectResponse<BigDecimal> getStoreCardBalance(Long parkId, String plateNum) {
        StoreCard storeCard = this.storeCardDao.selectValidateCard(parkId, plateNum);
        if (storeCard != null) {
            BigDecimal balance = storeCard.getBalance();
            return ObjectResponse.success((Object)balance);
        }
        return ObjectResponse.failed((String)"404");
    }

    public ObjectResponse<StoreCardRecord> getStoreCardRecordById(long recordId) {
        StoreCardRecord record = (StoreCardRecord)this.storedCardRecordDao.selectById(Long.valueOf(recordId));
        if (record == null) {
            return ObjectResponse.failed((String)"404", (String)("\u50a8\u503c\u5361\u64cd\u4f5c\u8bb0\u5f55[" + recordId + "]\u4e0d\u5b58\u5728"));
        }
        return ObjectResponse.success((Object)record);
    }

    public ObjectResponse<StoreCardUsed> getStoreCardUsedById(long usedId) {
        StoreCardUsed storeCardUsed = (StoreCardUsed)this.storeCardUsedDao.selectById(Long.valueOf(usedId));
        if (storeCardUsed == null) {
            return ObjectResponse.failed((String)"404", (String)"\u50a8\u503c\u5361\u4f7f\u7528\u8bb0\u5f55\u4e0d\u5b58\u5728");
        }
        return ObjectResponse.success((Object)storeCardUsed);
    }

    public List<StoreCardRecord> getStoreCarRecords(List<Long> parkIds, String startTime, String endTime, Integer type) {
        return this.storedCardRecordDao.getList(parkIds, startTime, endTime, type);
    }

    public Integer countRecords(List<Long> parkIds, String startTime, String endTime, Integer type) {
        return this.storedCardRecordDao.countRecords(parkIds, startTime, endTime, type);
    }

    public Double sumRecords(List<Long> parkIds, String startTime, String endTime, Integer type) {
        return this.storedCardRecordDao.sumRecords(parkIds, startTime, endTime, type);
    }

    @DS_SLAVE
    public List<StoredCardRecordDto> getStoredCardRecords(StoredCardRecordDto dto) {
        PageHelper.startPage((int)NumberUtils.toPrimitive((Integer)dto.getPageNo(), (int)1), (int)NumberUtils.toPrimitive((Integer)dto.getPageSize(), (int)10));
        return this.storedCardRecordDao.selectRecordList(dto);
    }

    @DS_SLAVE
    public StoreCardRecord getStoredCardRecordById(Long id) {
        return (StoreCardRecord)this.storedCardRecordDao.selectById(id);
    }

    public static int dateCompare(Date date1, Date date2) {
        int dateLastIntVal;
        if (date1 == null || date2 == null) {
            return 1;
        }
        SimpleDateFormat dateFormat = new SimpleDateFormat("yyyyMMdd");
        String dateFirst = dateFormat.format(date1);
        String dateLast = dateFormat.format(date2);
        int dateFirstIntVal = Integer.parseInt(dateFirst);
        if (dateFirstIntVal > (dateLastIntVal = Integer.parseInt(dateLast))) {
            return 1;
        }
        if (dateFirstIntVal < dateLastIntVal) {
            return -1;
        }
        return 0;
    }
}

