/*
 * Decompiled with CFR 0.152.
 */
package com.icetech.fee.service.monthcar.impl;

import cn.hutool.core.util.StrUtil;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.google.common.collect.Lists;
import com.icetech.basics.dao.park.ParkRegionDao;
import com.icetech.basics.domain.entity.park.ParkRegion;
import com.icetech.db.mybatis.base.service.impl.BaseServiceImpl;
import com.icetech.fee.dao.monthcar.MonthProductRegionMapper;
import com.icetech.fee.domain.entity.monthcar.MonthProductRegion;
import com.icetech.fee.service.monthcar.MonthProductRegionService;
import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.commons.collections4.CollectionUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class MonthProductRegionServiceImpl
extends BaseServiceImpl<MonthProductRegionMapper, MonthProductRegion>
implements MonthProductRegionService {
    @Autowired
    private ParkRegionDao parkRegionDao;

    @Override
    public MonthProductRegion getMonthProductRegionById(Long id) {
        return (MonthProductRegion)this.getById(id);
    }

    @Override
    public Boolean addMonthProductRegion(MonthProductRegion entity) {
        return this.save(entity);
    }

    @Override
    public Boolean modifyMonthProductRegion(MonthProductRegion entity) {
        return this.updateById(entity);
    }

    @Override
    public Boolean removeMonthProductRegionById(Long id) {
        return this.removeById(id);
    }

    @Override
    public String getRegionName(Long productId) {
        List monthProductRegions = this.list((Wrapper)Wrappers.lambdaQuery(MonthProductRegion.class).eq(MonthProductRegion::getProductId, (Object)productId));
        String regionName = "";
        if (CollectionUtils.isNotEmpty((Collection)monthProductRegions)) {
            List regionIds = monthProductRegions.stream().map(MonthProductRegion::getRegionId).collect(Collectors.toList());
            List parkRegions = this.parkRegionDao.selectBatchIds(regionIds);
            regionName = StrUtil.join((CharSequence)"/", (Iterable)parkRegions.stream().map(ParkRegion::getRegionName).collect(Collectors.toList()));
        }
        if (StrUtil.isEmpty((CharSequence)regionName)) {
            regionName = "\u5168\u8f66\u573a";
        }
        return regionName;
    }

    @Override
    public List<Integer> getRegionIds(Long productId) {
        List monthProductRegions = this.list((Wrapper)Wrappers.lambdaQuery(MonthProductRegion.class).eq(MonthProductRegion::getProductId, (Object)productId));
        if (CollectionUtils.isNotEmpty((Collection)monthProductRegions)) {
            return monthProductRegions.stream().map(MonthProductRegion::getRegionId).collect(Collectors.toList());
        }
        return Lists.newArrayList();
    }
}

