/*
 * Decompiled with CFR 0.152.
 */
package com.icetech.fee.service.merchant.impl;

import com.icetech.basics.dao.park.ParkDao;
import com.icetech.cloudcenter.api.discount.MerchantUserService;
import com.icetech.cloudcenter.domain.pay.MerchantRechargeDto;
import com.icetech.cloudcenter.domain.response.MerchantDto;
import com.icetech.cloudcenter.domain.response.MerchantUserDto;
import com.icetech.common.constants.CodeConstantsEnum;
import com.icetech.common.domain.response.ObjectResponse;
import com.icetech.fee.dao.merchant.MerchantRechargeDao;
import com.icetech.fee.dao.merchant.MerchantUserDao;
import com.icetech.fee.dao.merchant.ParkMerchantDao;
import com.icetech.fee.domain.entity.merchant.MerchantRecharge;
import com.icetech.fee.domain.entity.merchant.MerchantUser;
import com.icetech.fee.domain.entity.merchant.ParkMerchant;
import com.icetech.park.domain.entity.park.Park;
import java.math.BigDecimal;
import java.security.Key;
import java.util.Base64;
import java.util.Date;
import java.util.Objects;
import javax.crypto.Cipher;
import javax.crypto.spec.IvParameterSpec;
import javax.crypto.spec.SecretKeySpec;
import org.apache.commons.codec.digest.DigestUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service(value="merchantUserService")
public class MerchantUserServiceImpl
implements MerchantUserService {
    private static final Logger log = LoggerFactory.getLogger(MerchantUserServiceImpl.class);
    @Autowired
    private MerchantUserDao merchantUserDao;
    @Autowired
    private ParkMerchantDao parkMerchantDao;
    @Autowired
    private ParkDao parkDao;
    @Autowired
    private MerchantRechargeDao merchantRechargeDao;
    public static final String SECRET_KEY = "ZocNQD0mdfcmMKEWmtISpQ==";
    public static final String INIT_VECTOR = "Aocade0xxermMKEW";
    public static final String REGEX = "^(?=.*[a-zA-Z])(?=.*\\d).{8,16}$";

    public ObjectResponse<MerchantUserDto> login(String loginName, String password, String newPwd) {
        try {
            MerchantUser merchantUser = this.merchantUserDao.selectByLoginName(loginName);
            if (Objects.isNull(merchantUser)) {
                return ObjectResponse.failed((String)CodeConstantsEnum.ERROR_404.getCode(), (String)"\u7528\u6237\u4e0d\u5b58\u5728");
            }
            MerchantUserDto merchantUserDto = new MerchantUserDto();
            if (StringUtils.isNotBlank((CharSequence)newPwd)) {
                String decryptPwd = MerchantUserServiceImpl.decrypt(newPwd);
                if (StringUtils.isEmpty((CharSequence)decryptPwd)) {
                    return ObjectResponse.failed((String)"1000", (String)"\u5bc6\u7801\u9519\u8bef");
                }
                if (!DigestUtils.md5Hex((String)decryptPwd).equalsIgnoreCase(merchantUser.getPassword())) {
                    return ObjectResponse.failed((String)"1000", (String)"\u7528\u6237\u540d\u6216\u5bc6\u7801\u9519\u8bef");
                }
                if (decryptPwd.length() < 8 || decryptPwd.length() > 16 || !decryptPwd.matches(REGEX)) {
                    merchantUserDto.setUpdateFlag(Integer.valueOf(1));
                }
                ParkMerchant parkMerchant = new ParkMerchant();
                parkMerchant.setId(merchantUser.getMerchantId());
                ParkMerchant parkMerchantRes = (ParkMerchant)this.parkMerchantDao.selectById(parkMerchant);
                if (parkMerchantRes != null) {
                    merchantUserDto.setVisitPrivilege(parkMerchantRes.getVisitPrivilege());
                }
            } else if (!DigestUtils.md5Hex((String)password).equalsIgnoreCase(merchantUser.getPassword())) {
                return ObjectResponse.failed((String)"1000", (String)"\u7528\u6237\u540d\u6216\u5bc6\u7801\u9519\u8bef");
            }
            BeanUtils.copyProperties((Object)merchantUser, (Object)merchantUserDto);
            return ObjectResponse.success((Object)merchantUserDto);
        }
        catch (Exception e) {
            log.error("[\u767b\u5f55]\u5f02\u5e38: {}. loginName[{}]", new Object[]{e.getMessage(), loginName, e});
            return ObjectResponse.failed((String)CodeConstantsEnum.ERROR.getCode(), (String)CodeConstantsEnum.ERROR.getDesc());
        }
    }

    public ObjectResponse<MerchantDto> findMerchant(Integer merchantId) {
        ParkMerchant parkMerchant = new ParkMerchant();
        parkMerchant.setId(merchantId);
        ParkMerchant parkMerchantRes = (ParkMerchant)this.parkMerchantDao.selectById(parkMerchant);
        if (parkMerchantRes == null) {
            return ObjectResponse.failed((String)"404");
        }
        MerchantDto merchantDto = new MerchantDto();
        BeanUtils.copyProperties((Object)parkMerchantRes, (Object)merchantDto);
        Park park = this.parkDao.selectParkById(Long.valueOf(parkMerchantRes.getParkId()));
        merchantDto.setParkName(park.getParkName());
        return ObjectResponse.success((Object)merchantDto);
    }

    public ObjectResponse<MerchantDto> findMerchantByCode(String merchantCode) {
        ParkMerchant parkMerchantRes = this.parkMerchantDao.selectByCode(merchantCode);
        if (parkMerchantRes == null) {
            return ObjectResponse.failed((String)"404");
        }
        MerchantDto merchantDto = new MerchantDto();
        BeanUtils.copyProperties((Object)parkMerchantRes, (Object)merchantDto);
        Park park = this.parkDao.selectParkById(Long.valueOf(parkMerchantRes.getParkId()));
        merchantDto.setParkName(park.getParkName());
        return ObjectResponse.success((Object)merchantDto);
    }

    public ObjectResponse modifyPwd(Integer userId, String oldPwd, String newPwd) {
        String decryptPwd = MerchantUserServiceImpl.decrypt(oldPwd);
        String decryptNewPwd = MerchantUserServiceImpl.decrypt(newPwd);
        if (decryptNewPwd.length() < 8 || decryptNewPwd.length() > 16) {
            return ObjectResponse.failed((String)CodeConstantsEnum.ERROR_401.getCode(), (String)"\u8bf7\u8f93\u51658-16\u4f4d\u5bc6\u7801");
        }
        boolean flag = decryptNewPwd.matches(REGEX);
        if (!flag) {
            return ObjectResponse.failed((String)CodeConstantsEnum.ERROR_401.getCode(), (String)"\u5bc6\u7801\u9700\u5305\u542b\u5b57\u6bcd\u548c\u6570\u5b57\uff0c\u957f\u5ea6\u57288-16\u4e4b\u95f4");
        }
        int n = this.merchantUserDao.updatePwd(userId, DigestUtils.md5Hex((String)decryptPwd), DigestUtils.md5Hex((String)decryptNewPwd));
        if (n == 0) {
            return ObjectResponse.failed((String)"402", (String)"\u539f\u5bc6\u7801\u9519\u8bef");
        }
        return ObjectResponse.success();
    }

    public ObjectResponse modifyPhoto(Integer userId, String photoPath) {
        MerchantUser merchantUser = new MerchantUser();
        merchantUser.setId(userId);
        merchantUser.setImgUrl(photoPath);
        Integer n = this.merchantUserDao.update(merchantUser);
        if (n == 0) {
            return ObjectResponse.failed((String)"402");
        }
        return ObjectResponse.success();
    }

    public ObjectResponse<Void> subMerchantMoney(Integer merchantId, BigDecimal bigDecimal) {
        if (bigDecimal.doubleValue() == 0.0) {
            log.info("[\u5546\u6237\u4f18\u60e0\u4f59\u989d\u64cd\u4f5c] \u5546\u6237ID:{}\u7684\u4f18\u60e0\u4f59\u989d\u4e0d\u9700\u8981\u6263\u9664(\u56e0\u4e3a\u6263\u9664\u91d1\u989d\u53c2\u6570\u662f0)", (Object)merchantId);
            return ObjectResponse.success();
        }
        ParkMerchant parkMerchant = new ParkMerchant();
        parkMerchant.setId(merchantId);
        ParkMerchant ret = (ParkMerchant)this.parkMerchantDao.selectById(parkMerchant);
        if (Objects.isNull(ret)) {
            return ObjectResponse.failed((String)"404");
        }
        ret.setBalance(ret.getBalance().subtract(bigDecimal));
        log.info("[\u5546\u6237\u4f18\u60e0\u4f59\u989d\u64cd\u4f5c] \u5546\u6237ID:{}\u7684\u4f18\u60e0\u4f59\u989d\u6263\u51cf{}\u5143", (Object)merchantId, (Object)bigDecimal);
        this.parkMerchantDao.update(ret);
        return ObjectResponse.success();
    }

    public ObjectResponse<Void> addMerchantMoney(Integer merchantId, BigDecimal bigDecimal) {
        if (bigDecimal.doubleValue() == 0.0) {
            log.info("[\u5546\u6237\u4f18\u60e0\u4f59\u989d\u64cd\u4f5c] \u5546\u6237ID:{}\u7684\u4f18\u60e0\u4f59\u989d\u4e0d\u9700\u8981\u9000\u8d39(\u56e0\u4e3a\u9000\u8d39\u91d1\u989d\u53c2\u6570\u662f0)", (Object)merchantId);
            return ObjectResponse.success();
        }
        ParkMerchant parkMerchant = new ParkMerchant();
        parkMerchant.setId(merchantId);
        ParkMerchant ret = (ParkMerchant)this.parkMerchantDao.selectById(parkMerchant);
        if (Objects.isNull(ret) || ret.getStatus() == 1) {
            log.info("[\u5546\u6237\u4f18\u60e0\u4f59\u989d\u64cd\u4f5c] \u5546\u6237ID:{}\u5546\u6237\u4e0d\u5b58\u5728\u6216\u8005\u5df2\u7ecf\u5220\u9664", (Object)merchantId);
            return ObjectResponse.failed((String)"404");
        }
        ret.setBalance(ret.getBalance().add(bigDecimal));
        log.info("[\u5546\u6237\u4f18\u60e0\u4f59\u989d\u64cd\u4f5c] \u5546\u6237ID:{}\u7684\u4f18\u60e0\u4f59\u989d\u65b0\u589e{}\u5143", (Object)merchantId, (Object)bigDecimal);
        this.parkMerchantDao.update(ret);
        return ObjectResponse.success();
    }

    public ObjectResponse<Void> finishRecharge(MerchantRechargeDto dto) {
        MerchantRecharge query = new MerchantRecharge();
        query.setTradeNo(dto.getTradeNo());
        MerchantRecharge merchantRechargeOld = (MerchantRecharge)this.merchantRechargeDao.selectLimitOne(query);
        if (Objects.nonNull(merchantRechargeOld)) {
            return ObjectResponse.success();
        }
        BigDecimal amount = new BigDecimal(dto.getAmount());
        ParkMerchant parkMerchant = this.parkMerchantDao.selectByCode(dto.getMerchantCode());
        BigDecimal balance = parkMerchant.getBalance();
        parkMerchant.setBalance(balance.add(amount));
        MerchantRecharge merchantRecharge = new MerchantRecharge();
        merchantRecharge.setParkId(Integer.valueOf(Math.toIntExact(dto.getParkId())));
        merchantRecharge.setMerchantId(parkMerchant.getId());
        merchantRecharge.setRechargePrice(amount);
        merchantRecharge.setBalance(parkMerchant.getBalance());
        merchantRecharge.setRechargeTime(new Date());
        merchantRecharge.setTradeNo(dto.getTradeNo());
        merchantRecharge.setRechargeType(dto.getRechargeType());
        merchantRecharge.setOperator(dto.getOperator());
        merchantRecharge.setCreateTime(new Date());
        merchantRecharge.setPayMoney(amount);
        merchantRecharge.setPayWay(dto.getPayWay());
        this.merchantRechargeDao.insert(merchantRecharge);
        this.parkMerchantDao.update(parkMerchant);
        return ObjectResponse.success();
    }

    public ObjectResponse<Void> orderResult(String tradeNo) {
        MerchantRecharge query = new MerchantRecharge();
        query.setTradeNo(tradeNo);
        MerchantRecharge merchantRecharge = (MerchantRecharge)this.merchantRechargeDao.selectLimitOne(query);
        return Objects.nonNull(merchantRecharge) ? ObjectResponse.success() : ObjectResponse.failed();
    }

    public static String decrypt(String encrypted) {
        try {
            SecretKeySpec key = new SecretKeySpec(SECRET_KEY.getBytes("UTF-8"), "AES");
            IvParameterSpec iv = new IvParameterSpec(INIT_VECTOR.getBytes("UTF-8"));
            Cipher cipher = Cipher.getInstance("AES/CBC/PKCS5PADDING");
            cipher.init(2, (Key)key, iv);
            byte[] original = cipher.doFinal(Base64.getDecoder().decode(encrypted));
            return new String(original);
        }
        catch (Exception e) {
            log.error("[\u767b\u5f55]\u89e3\u5bc6\u5931\u8d25,\u9519\u8bef\u4fe1\u606f{}", (Object)e.getMessage());
            return "";
        }
    }
}

