package com.icetech.fee.service.monthcar;

import com.icetech.db.mybatis.base.service.IBaseService;
import com.icetech.fee.domain.entity.monthcar.MonthApplyRecord;

/**
 * 月卡线上开通申请表 服务类
 *
 * Copyright (c) Department of Research and Development/Beijing
 * All Rights Reserved
 *
 * @author wangzhiwei
 * @version 1.0 @date 2024-04-24
 */
public interface MonthApplyRecordService extends IBaseService<MonthApplyRecord> {

    /**
     * Description: 根据ID查询 月卡线上开通申请表对象信息 <br>
     * Version1.0 2024-04-24 by wangzhiwei创建
     *
     * @param id 对象id
     * @return MonthApplyRecord
     */
    MonthApplyRecord getMonthApplyRecordById (Long id);

    /**
     * Description: 新增  月卡线上开通申请表对象信息 <br>
     * Version1.0 2024-04-24 by wangzhiwei创建
     *
     * @param entity 对象信息
     * @return Boolean 返回新增后主键
     */
    Boolean addMonthApplyRecord (MonthApplyRecord entity);

    /**
     * Description: 修改 月卡线上开通申请表对象信息 <br>
     * Version1.0 2024-04-24 by wangzhiwei创建
     *
     * @param entity 对象信息
     * @return Boolean 返回更新后的结果
     */
    Boolean modifyMonthApplyRecord (MonthApplyRecord entity);

    /**
     * Description: 删除  月卡线上开通申请表对象信息 <br>
     * Version1.0 2024-04-24 by wangzhiwei创建
     *
     * @param id 对象id
     * @return Boolean 返回更新后的结果
     */
    Boolean removeMonthApplyRecordById (Long id);
}
