package com.icetech.fee.dao.merchant;

import com.icetech.fee.domain.entity.merchant.MerchantUser;
import com.icetech.db.dao.BaseDao;
import org.apache.ibatis.annotations.Param;
import org.springframework.stereotype.Component;

/**
 * 商户管理员表
 *
 * Created by xuxueli on '2019-02-15 14:09:24'.
 */
@Component
public interface MerchantUserDao extends BaseDao<MerchantUser> {


    /**
     * 查询用户信息
     * @param loginName 用户名称或者手机号
     * @return
     */
    MerchantUser selectByLoginName(@Param("loginName") String loginName);

    /**
     * 修改密码
     * @param userId
     * @param oldPwd
     * @param newPwd
     * @return
     */
    int updatePwd(@Param("userId") Integer userId,
                           @Param("oldPwd") String oldPwd,
                           @Param("newPwd") String newPwd);

    /**
     * 更新头像
     * @param userId
     * @param photoPath
     * @return
     */
    int updatePhoto(@Param("id") Integer userId,
                             @Param("photoPath") String photoPath);
}
