package com.icetech.fee.service.monthcar.impl;

import com.icetech.db.mybatis.base.service.impl.BaseServiceImpl;
import com.icetech.fee.dao.monthcar.MonthApplyRecordMapper;
import com.icetech.fee.domain.entity.monthcar.MonthApplyRecord;
import com.icetech.fee.service.monthcar.MonthApplyRecordService;
import org.springframework.stereotype.Service;

/**
 * 月卡线上开通申请表 服务实现类
 *
 * Copyright (c) Department of Research and Development/Beijing
 * All Rights Reserved
 *
 * @author wangzhiwei
 * @version 1.0 @date 2024-04-24
 */
@Service
public class MonthApplyRecordServiceImpl extends BaseServiceImpl<MonthApplyRecordMapper, MonthApplyRecord> implements MonthApplyRecordService {

    /**
     * Description: 根据ID查询 月卡线上开通申请表对象信息 <br>
     * Version1.0 2024-04-24 by wangzhiwei创建
     *
     * @param id 对象id
     * @return MonthApplyRecord
     */
    @Override
    public MonthApplyRecord getMonthApplyRecordById (Long id) {
        return getById(id);
    }

    /**
     * Description: 新增  月卡线上开通申请表对象信息 <br>
     * Version1.0 2024-04-24 by wangzhiwei创建
     *
     * @param entity 对象信息
     * @return Boolean 返回新增后主键
     */
    @Override
    public Boolean addMonthApplyRecord (MonthApplyRecord entity) {
        return save(entity);
    }

    /**
     * Description: 修改 月卡线上开通申请表对象信息 <br>
     * Version1.0 2024-04-24 by wangzhiwei创建
     *
     * @param entity 对象信息
     * @return Boolean 返回更新后的结果
     */
    @Override
    public Boolean modifyMonthApplyRecord (MonthApplyRecord entity) {
        return updateById(entity);
    }

    /**
     * Description: 删除  月卡线上开通申请表对象信息 <br>
     * Version1.0 2024-04-24 by wangzhiwei创建
     *
     * @param id 对象id
     * @return Boolean 返回更新后的结果
     */
    @Override
    public Boolean removeMonthApplyRecordById (Long id) {
        return removeById(id);
    }

}
