package com.icetech.fee.dao.monthcar;

import com.icetech.fee.domain.entity.monthcar.MonthRegion;
import org.apache.ibatis.annotations.Param;
import org.springframework.stereotype.Component;

import java.util.List;

/**
 * 月卡区域操作
 *
 * Created by xuxueli on '2019-07-08 14:16:01'.
 */
@Component
public interface MonthRegionDao {

    /**
     * 根据月卡ID查询月卡区域列表
     * @param monthId
     * @return
     */
    List<MonthRegion> selectByMonthId(long monthId);

    /**
     * 根据月卡id删除关联关系
     * @param monthId
     */
    void deleteByMonthId(@Param("monthId") Integer monthId);

    /**
     *  插入
     * @param monthRegion
     */
    Integer insert(MonthRegion monthRegion);
}
