package com.icetech.fee.dao.monthcar;

import com.icetech.fee.domain.entity.monthcar.MonthProduct;
import org.apache.ibatis.annotations.Param;
import org.springframework.stereotype.Component;

import java.util.List;

/**
 * 月卡产品表
 *
 * Created by xuxueli on '2019-07-08 14:35:35'.
 */
@Component
public interface MonthProductDao {

    /**
     * 新增
     */
    int insert(MonthProduct monthProduct);

    /**
     * 删除
     */
    int delete(@Param("id") long id);

    /**
     * 更新
     */
    int update(@Param("monthProduct") MonthProduct monthProduct);

    /**
     * Load查询
     */
    MonthProduct selectById(@Param("id") long id);

    /**
     * 根据车场id 查询月卡产品信息
     * @param parkId
     * @return
     */
    MonthProduct selectOneByParkId(@Param("parkId") Long parkId);

    /**
     * 查询生效中的且允许续费的月卡产品
     * @param parkId
     * @return
     */
    List<MonthProduct> selectListByParkId(@Param("parkId") Long parkId);

    List<MonthProduct> selectListBy(@Param("parkIds") List<Long> parkIds, @Param("cardType") Integer cardType);

    /**
     * 通过id批量获取
     *
     * @param productIds
     * @return
     */
    List<MonthProduct> selectByIds(@Param("productIds") List<Long> productIds);
}
