package com.icetech.fee.domain.entity.vip;

import lombok.Data;

import java.io.Serializable;
import java.util.Date;

/**
 * ice_vip_record
 * @author
 */
@Data
public class VipRecord implements Serializable {
    private Integer id;

    /**
     * 车场ID
     */
    private Integer parkId;

    /**
     * VIP信息表id
     */
    private Integer vipId;

    /**
     * VIP类型id
     */
    private Integer typeId;

    /**
     * 车牌号，多个车牌之间用逗号隔开
     */
    private String plateNum;

    /**
     * 操作类型，1：添加，2：编辑，3：删除
     */
    private Integer operType;

    /**
     * 姓名
     */
    private String owner;

    /**
     * 电话
     */
    private String phone;

    /**
     * 有效开始日期
     */
    private Date startTime;

    /**
     * 有效结束日期
     */
    private Date endTime;

    /**
     * 备注
     */
    private String remark;

    /**
     * 办理人
     */
    private String operAccount;

    /**
     * 操作时间
     */
    private Date operTime;

    private static final long serialVersionUID = 1L;

}
