package com.icetech.fee.domain.entity.storecard;

import lombok.Data;

import java.io.Serializable;
import java.math.BigDecimal;
import java.util.Date;

/**
 * TODO
 *
 * @author zhangpengzhan
 * @date 2020/8/3 9:38
 * @description: 储值卡信息表
 */
@Data
public class StoreCard implements Serializable {
    /**
     * 主键自增长id
     */
    private Integer id;

    /**
     * 车场id
     */
    private Integer parkId;

    /**
     * 	储值卡编号
     */
    private String cardsNum;

    /**
     * 姓名
     */
    private String cardOwner;

    /**
     * 手机号码
     */
    private String phone;

    /**
     * 地址
     */
    private String address;

    /**
     * 	有效开始日期
     */
    private Date startTime;

    /**
     * 有效结束日期
     */
    private Date endTime;

    /**
     * 可用余额
     */
    private BigDecimal balance;

    /**
     * 状态（0：正常，1：删除，默认0）
     */
    private Integer deleteStatus;

    /**
     * 状态 0正常 1过期
     */
    private Integer cardsStatus;

    /**
     * 备注
     */
    private String remark;

    /**
     * 	添加人
     */
    private String adder;

    /**
     * 	最后编辑人
     */
    private String editer;

    /**
     * 创建时间
     */
    private Date createTime;

    /**
     * 修改时间
     */
    private Date updateTime;
}
