package com.icetech.fee.domain.entity.monthcar;

import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableName;
import lombok.Getter;
import lombok.Setter;
import lombok.ToString;

import java.io.Serializable;
import java.util.Date;

/**月卡操作记录表*/
@Getter
@Setter
@ToString
@TableName(value = "`ice_month_record`")
public class MonthRecord implements Serializable {
    private static final long serialVersionUID = 1L;

    /** 主键自增长id */
    @TableId(value = "`id`")
    protected Long id;
    /** 月卡id */
    @TableField(value = "`month_id`")
    protected Long monthId;
    /** 月卡产品id */
    @TableField(value = "`product_id`")
    protected Long productId;
    /** 车场id */
    @TableField(value = "`park_id`")
    protected Long parkId;
    /** 申办性质 */
    @TableField(value = "`card_property`")
    protected Integer cardProperty;
    /** 月卡所属人姓名/公司名称 */
    @TableField(value = "`card_owner`")
    protected String cardOwner;
    /** 车牌号多个英文,隔开 */
    @TableField(value = "`plate_num`")
    protected String plateNum;
    /** 车位号多个英文,隔开 */
    @TableField(value = "`space_num`")
    protected String spaceNum;
    /** 区域id多个英文,隔开 */
    @TableField(value = "`region_id`")
    protected String regionId;
    /** 手机号码 */
    @TableField(value = "`phone`")
    protected String phone;
    /** 操作类型1 新增 2 续费 3 修改 4 退卡 */
    @TableField(value = "`card_opertype`")
    protected Integer cardOpertype;
    /** 是否逾期(仅当操作类型为2时有效 1 是 0 否 */
    @TableField(value = "`is_overdue`")
    protected Integer isOverdue;
    /** 车位数 */
    @TableField(value = "`plot_count`")
    protected Integer plotCount;
    /** 购买数量 */
    @TableField(value = "`count`")
    protected Integer count;
    /** 支付金额 */
    @TableField(value = "`pay_money`")
    protected Double payMoney;
    /** 押金 */
    @TableField(value = "`deposit`")
    protected Double deposit;
    /** 支付方式(0 现金，1 银行卡 2：微信 3：支付宝) */
    @TableField(value = "`pay_method`")
    protected Integer payMethod;
    /**
     * 支付渠道
     */
    @TableField(value = "`pay_channel`")
    protected Integer payChannel;
    /** 退卡金额 */
    @TableField(value = "`refund`")
    protected Double refund;
    /** 月卡有效开始日期 */
    @TableField(value = "`start_time`")
    protected Date startTime;
    /** 月卡有效结束日期 */
    @TableField(value = "`end_time`")
    protected Date endTime;
    /** 操作人 */
    @TableField(value = "`oper_account`")
    protected String operAccount;
    /** 备注 */
    @TableField(value = "`remark`")
    protected String remark;
    /** 创建时间 */
    @TableField(value = "`create_time`")
    protected Date createTime;
    /** 操作时间 */
    @TableField(value = "`update_time`")
    protected Date updateTime;
    /** 月卡暂停实际开始时间,仅操作类型为暂停和恢复时有效 */
    @TableField(value = "`cardstop_start`")
    protected Date cardstopStart;
    /** 月卡暂停计划结束时间 */
    @TableField(value = "`cardstop_end`")
    protected Date cardstopEnd;
    /** 月卡暂停实际结束时间 */
    @TableField(value = "`cardstop_realyend`")
    protected Date cardstopRealyend;
    /** 月卡额外天数 */
    @TableField(value = "`add_day`")
    protected String addDay;
    /** 月卡额外收费 */
    @TableField(value = "`add_amount`")
    protected Double addAmount;
    /** 车主地址 */
    @TableField(value = "`main_address`")
    protected String mainAddress;
    /** 是否下发（0未下发，1已下发，2错误，默认0 */
    @TableField(value = "`send_type`")
    private Integer sendType;
    /** 状态(0待下发1成功2暂不下发3延迟下发4失败，默认0 */
    @TableField(value = "`send_status`")
    private Integer sendStatus;

    public enum CardOpertype{
        新增 (1),
        续费 (2),
        修改 (3),
        退卡 (4),
        ;
        private @Getter Integer type;
        CardOpertype (Integer type){
            this.type = type;
        }
    }
    public enum PayMethod{
        现金 (0),
        银行卡 (1),
        微信 (2),
        支付宝 (3),
        其他 (3),
        ;
        private @Getter Integer type;
        PayMethod (Integer type){
            this.type = type;
        }
    }
}
