package com.icetech.fee.domain.entity.monthcar;

import lombok.Data;

import java.io.Serializable;
import java.math.BigDecimal;
import java.sql.Time;
import java.util.Date;

/**
 * 月卡产品表
 * <p>
 * Created by xuxueli on '2019-07-08 14:35:35'.
 */
@Data
public class MonthProduct implements Serializable {
    private static final long serialVersionUID = 42L;

    /**
     * id
     */
    private Long id;

    /**
     * 产品名称
     */
    private String name;

    /**
     * 车场id
     */
    private Long parkId;

    /**
     * 产品面额（1个月2个月等）
     */
    private int duration;

    /**
     * 适用时段1全天2分时段，区分工作日非工作日时，此值为工作日适用时段
     */
    private int cardType;

    /**
     *
     */
    private BigDecimal paymoney;

    /**
     * 开始日期 产品可用日期，区分工作日非工作日时，此值为工作日开始日期
     */
    private Date startDate;

    /**
     * 结束日期 产品可用日期，区分工作日非工作日时，此值为工作日结束日期'
     */
    private Date endDate;

    /**
     * 开始时间点 产品可用时间
     */
    private Time startTime;

    /**
     * 结束时间点（跨天开始>结束）
     */
    private Time endTime;

    /**
     * 审核状态（默认0未审核1通过2未通过）
     */
    private int checkStatus;

    /**
     * 购买渠道 0：仅平台可购买 1：平台和公众号均可购买 默认为0
     */
    private int buyChannel;

    /**
     * 是否支持用户短信通知 0：不支持，1：支持 默认为0
     */
    private int isUserSms;

    /**
     * 月卡仅剩**天，短信通知
     */
    private int remainDay;

    /**
     * 是否赠送天数 0：不赠送 1：赠送 默认为0
     */
    private int isDiftDay;

    /**
     * 赠送多少天 默认0
     */
    private int diftDays;

    /**
     * 所售状态0 未售  1 在售  2 停售 3 过期
     */
    private int status;
    /**
     * 支持分区数据1支持0不支持 (老数据不支持分区，paas创建的也不支持分区)
     */
    private int supportRegion;

    /**
     * 审核说明
     */
    private String feedback;

    /**
     * 添加人
     */
    private String adder;

    /**
     * 修改人
     */
    private String editer;

    /**
     * 是否删除0：正常 1：删除默认0
     */
    private int delflag;

    /**
     * 添加时间
     */
    private Date createTime;

    /**
     * 修改时间
     */
    private Date updateTime;


    /**
     * 续费人群范围 0:所有人 1：特定人群
     */
    private Integer renewAlscope;
    /**
     * 公众号续费生效方式 0:支付成功生效 1 审核后生效 默认为0
     */
    private Integer renewstatusValid;
    /**
     * 公众号开卡 0：不允许 1：允许 默认为0
     */
    private Integer accountSales;
    /**
     * 公众号开卡生效方式 0:支付成功生效 1 审核后生效 默认为0
     */
    private Integer addstatusValid;
    /**
     * 是否区分工作日非工作日,0:不区分 1：区分 默认为0
     */
    private Integer diffWorkday;
    /**
     * 非工作日收费类型，1：全天免费，2：全天临时车收费
     */
    private Integer notWorkdayCharge;

    /**
     * 描述标签
     */
    private String tagContent;

    /**
     * 使用规则
     */
    private String userChareg;

    /**
     * 线上可售月卡总量
     */
    private Integer totalOnlineQuantity;

    /**
     * 购买须知
     */
    private String buyNotice;

    /**
     * 客服电话
     */
    private String customerServicePhone;

    /**
     * 是否允许欠费车辆办理开卡续费 默认0，0否，1是
     */
    private Integer isAllowedCardArrears;

    private BigDecimal deposit;

    /**
     * 是否需要有押金 默认0,0否，1是',
     */
    private Integer isHaveDeposit;
}
