package com.icetech.fee.domain.entity.merchant;

import lombok.Data;

import java.io.Serializable;
import java.math.BigDecimal;
import java.util.Date;

/**
 *  停车场商户信息表
 *
 *  Created by xuxueli on '2019-02-15 14:19:46'.
 */
@Data
public class ParkMerchant implements Serializable {
    private static final long serialVersionUID = 42L;

    /**
     * id
     */
    private Integer id;

    /**
     * 停车场id
     */
    private int parkId;

    /**
     * 商户号
     */
    private String code;

    /**
     * 商户名称
     */
    private String name;

    /**
     * 负责人手机号
     */
    private String phone;

    /**
     * 是否可透支余额，0：否，1：是
     */
    private int overdrawFlag;

    /**
     *可透支金额
     */
    private BigDecimal overdrawAmount;

    /**
     *可用余额
     */
    private BigDecimal balance;

    /**
     * 系统自动添加 0不支持，1支持
     */
    private Integer isQrcode;

    /**
     * 状态，0：正常，1：删除
     */
    private int status;

    /**
     * 是否支持在线充值 1=支持 0=不支持
     */
    private Integer recharge;

    /**
     * 添加人
     */
    private String adder;

    /**
     * 创建时间
     */
    private Date createTime;

    /**
     * 修改人
     */
    private String editer;

    /**
     * 更新时间
     */
    private Date updateTime;

    /**
     * 当前可优免车位数
     */
    private Integer spaceNum;

    /**
     * 静态码领取时限 1=限时 0=不限时
     */
    private Integer isLimitTime;

    /**
     * 静态码领取限制时长
     */
    private Integer limitTime;

    /**
     * 有访客车的权限，0：否，1：是
     */
    private Integer visitPrivilege;
}
