package com.icetech.fee.domain.entity.merchant;

import lombok.Data;

import java.io.Serializable;
import java.math.BigDecimal;
import java.util.Date;

/**
 *  商户优惠模板表
 *
 *  Created by xuxueli on '2019-02-15 14:38:03'.
 */
@Data
public class MerchantDiscount implements Serializable {
    private static final long serialVersionUID = 42L;

    /**
     * id
     */
    private int id;

    /**
     * 停车场id
     */
    private Long parkId;

    /**
     * 商户id
     */
    private int merchantId;

    /**
     * 模板编号
     */
    private String code;

    /**
     * 优惠券名称
     */
    private String name;

    /**
     * 优惠类型1全免2减免时间3减免金额4折扣
     */
    private int type;

    /**
     * 优惠数额
     */
    private String amount;

    /**
     * 最大优惠天数
     */
    private Integer amountday;

    /**
     * 商家扣除余额类型：
     * 优惠类型为1时，1：按时长计费后扣除，2按金额(元)扣除；
     * 当优惠类型为4时，1：按计费折算后扣除，2按金额(元)扣除；
     */
    private int deductType;

    /**
     *
     */
    private BigDecimal deductMoney;

    /**
     * 有效期开始时间
     */
    private Date startTime;

    /**
     * 有效期结束时间
     */
    private Date endTime;

    /**
     * 备注
     */
    private String remark;

    /**
     * 状态，0：正常，1：删除
     */
    private Integer status;

    /**
     * 操作人
     */
    private String operAccount;

    /**
     * 创建时间
     */
    private Date createTime;

    /**
     * 更新人
     */
    private String updateUser;

    /**
     * 更新时间
     */
    private Date updateTime;

    /**
     * 停车时长超过 X 分钟不能领取优惠 -1表示不限制
     */
    private Integer maxparkingTime;

    /**
     * 优惠码有效时长
     */
    private Integer discodeTimelong;
    /**
     * 自然天内一个车牌号只可领取一次优惠，0：否，1：是，默认0
     */
    private Integer onceDay;
    /**
     * 过期时长 0表示不限制,单位小时
     */
    private Integer expireLongtime;
    /**
     * 使用时间类型 1当次在场车辆离场前可使用，2 领券后几小时有效
     */
    private Integer useType;

    /**
     * 系统自动添加 0不支持，1支持
     */
    private Integer isQrcode;

    /**
     * 静态码领取时限 1=限时 0=不限时
     */
    private Integer isLimitTime;


    /**
     * 静态码领取限制时长
     */
    private Integer limitTime;

    /**
     * 车牌颜色限制类型(逗号,隔开) 1:所有车辆都可领取，2:蓝牌车可领，3:绿牌车可领，4:黄牌车可领，5:白牌车可领，6:黑牌车可领，7:黄绿牌车可领
     */
    private String carcolorType;

    /**
     * 优惠天数(按天优免起效)
     */
    private Integer discountDays;
    /**
     * 场中场车场限制优惠发放的区域ID集合，0代表不限制，多个区域ID用逗号隔开
     */
    private String regionLimit;
    /** 全免优惠券支持优惠核销时，对计费折算后打折扣除，折扣取值 1-10;默认为 10 */
    private Integer disDeductValue;
}
