package com.icetech.fee.domain.entity.vip;

import com.baomidou.mybatisplus.annotation.TableName;
import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.annotation.TableId;
import java.io.Serializable;

import lombok.*;

/**
 * VIP类型关联区域表
 * Copyright (c) Department of Research and Development/Beijing
 * All Rights Reserved
 *
 * @author wanggang
 * @version 1.0 @date 2021-11-04
 */
@Data
@EqualsAndHashCode(callSuper = false)
@TableName("ice_vip_region")
@AllArgsConstructor
@NoArgsConstructor
@Builder
public class VipRegion implements Serializable {

    private static final long serialVersionUID=1L;

    /**
     * 主键自增长id
     */
    @TableId(value = "id", type = IdType.AUTO)
    private Integer id;

    /**
     * vip类型id
     */
    private Integer typeId;

    /**
     * 区域id，全车场时值为0
     */
    private Long regionId;

    /**
     * 计费id （ice_park_chargeconfig表中自增id）
     */
    private Integer billId;


}
