package com.icetech.fee.domain.entity.vip;

import java.io.Serializable;
import java.util.Date;

import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableName;
import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.NoArgsConstructor;

/**
 * ice_vip_plate
 *
 * @author
 */
@Data
@TableName("`ice_vip_plate`")
@EqualsAndHashCode(callSuper = false)
@NoArgsConstructor
@Builder
@AllArgsConstructor
public class VipPlate implements Serializable {
    private static final long serialVersionUID = 1L;

    @TableId(value = "id", type = IdType.AUTO)
    private Long id;
    /**
     * VIP信息表id
     */
    @TableField(value = "`vip_id`")
    protected Long vipId;

    /**
     * 车场id
     */
    @TableField(value = "`park_id`")
    private Integer parkId;

    /**
     * 车牌号
     */
    @TableField(value = "`plate_num`")
    protected String plateNum;
    /**
     * 姓名
     */
    @TableField(value = "`owner`")
    protected String owner;
    /**
     * 电话
     */
    @TableField(value = "`phone`")
    protected String phone;
    /**
     * 有效开始日期
     */
    @TableField(value = "`start_time`")
    protected Date startTime;
    /**
     * 有效结束日期
     */
    @TableField(value = "`end_time`")
    protected Date endTime;

    /**
     * 单位
     */
    @TableField(value = "`unit`")
    private String unit;

    /**
     * 备注
     */
    @TableField(value = "`remark`")
    private String remark;
}
