package com.icetech.fee.domain.entity.storecard;

import java.io.Serializable;
import java.util.Date;

import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableName;
import lombok.Data;

@Data
@TableName("`ice_storedcard_record`")
public class StoreCardRecord implements Serializable {
    /**
     * 主键自增长id
     */
    @TableId(value = "`id`")
    protected Long id;
    /**
     * 储值卡表id
     */
    @TableField(value = "`card_id`")
    protected Long cardId;
    /**
     * 车场id
     */
    @TableField(value = "`park_id`")
    protected Long parkId;
    /**
     * 姓名
     */
    @TableField(value = "`card_owner`")
    protected String cardOwner;
    /**
     * 手机号码
     */
    @TableField(value = "`phone`")
    protected String phone;
    /**
     * 地址
     */
    @TableField(value = "`address`")
    protected String address;
    /**
     * 有效开始日期
     */
    @TableField(value = "`start_time`")
    protected Date startTime;
    /**
     * 有效结束日期
     */
    @TableField(value = "`end_time`")
    protected Date endTime;
    /**
     * 可用余额
     */
    @TableField(value = "`balance`")
    protected Double balance;
    /**
     * 车牌号多个英文,隔开
     */
    @TableField(value = "`plate_num`")
    protected String plateNum;
    /**
     * 区域id多个英文,隔开
     */
    @TableField(value = "`region_id`")
    protected String regionId;
    /**
     * 操作类型1 新增 2 充值 3 编辑 4 删除
     */
    @TableField(value = "`card_opertype`")
    protected Integer cardOperType;
    /**
     * 充值金额
     */
    @TableField(value = "`recharge_price`")
    protected Double rechargePrice;
    /**
     * 充值后金额
     */
    @TableField(value = "`recharge_balance`")
    protected Double rechargeBalance;
    /**
     * 支付金额
     */
    @TableField(value = "`pay_money`")
    protected Double payMoney;
    /**
     * 操作人
     */
    @TableField(value = "`oper_account`")
    protected String operAccount;
    /**
     * 操作时间
     */
    @TableField(value = "`update_time`")
    protected Date updateTime;
    /**
     * 备注
     */
    @TableField(value = "`remark`")
    protected String remark;
}
