package com.icetech.fee.domain.entity.storecard;

import java.io.Serializable;
import java.util.Date;

import com.baomidou.mybatisplus.annotation.FieldStrategy;
import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableName;
import lombok.Getter;
import lombok.Setter;
import lombok.ToString;

/**
 * 储值卡充值记录表
 */
@Getter
@Setter
@ToString
@TableName(value = "`ice_storedcard_recharge`")
public class StoreCardRecharge implements Serializable {
    private static final long serialVersionUID = 1L;

    /**
     *
     */
    @TableId(value = "`id`")
    protected Long id;
    /**
     * 停车场id
     */
    @TableField(value = "`park_id`")
    protected Long parkId;
    /**
     * 储值卡表id
     */
    @TableField(value = "`card_id`")
    protected Long cardId;
    /**
     * 充值金额
     */
    @TableField(value = "`recharge_price`")
    protected Double rechargePrice;
    /**
     * 储值卡余额
     */
    @TableField(value = "`balance`")
    protected Double balance;
    /**
     * 充值方式,1:线下充值
     */
    @TableField(value = "`recharge_type`")
    protected Integer rechargeType;
    /**
     * 操作人
     */
    @TableField(value = "`operator`")
    protected String operator;
    /**
     * 实付金额
     */
    @TableField(value = "`pay_money`")
    protected Double payMoney;
    /**
     * 充值时间
     */
    @TableField(value = "`create_time`", updateStrategy = FieldStrategy.NEVER)
    protected Date createTime;
}
