package com.icetech.fee.domain.entity.monthcar;

import java.math.BigDecimal;
import com.baomidou.mybatisplus.annotation.TableName;
import com.baomidou.mybatisplus.annotation.IdType;
import java.util.Date;
import java.time.LocalDate;
import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.FieldFill;
import com.baomidou.mybatisplus.annotation.TableField;
import java.io.Serializable;

import lombok.*;

/**
 * 月卡续费审核表
 * Copyright (c) Department of Research and Development/Beijing
 * All Rights Reserved
 *
 * @author wanggang
 * @version 1.0 @date 2021-12-31
 */
@Builder
@AllArgsConstructor
@Data
@EqualsAndHashCode(callSuper = false)
@NoArgsConstructor
@TableName("ice_monthrenewe_pubcheck")
public class MonthrenewePubcheck implements Serializable {

    private static final long serialVersionUID=1L;

    /**
     * 主键自增长id
     */
    @TableId(value = "id", type = IdType.AUTO)
    private Integer id;

    /**
     * 月卡id
     */
    private Integer monthId;

    /**
     * 月卡产品id
     */
    private Integer productId;

    /**
     * 车场id
     */
    private Integer parkId;

    /**
     * 申办性质
     */
    private Integer cardProperty;

    /**
     * 月卡所属人姓名/公司名称
     */
    private String cardOwner;

    /**
     * 车牌号多个英文,隔开
     */
    private String plateNum;

    /**
     * 车位号多个英文,隔开
     */
    private String spaceNum;

    /**
     * 区域id多个英文,隔开
     */
    private String regionId;

    /**
     * 手机号码
     */
    private String phone;

    /**
     * 月卡状态 1 开卡 2 续费
     */
    private Integer cardStatus;

    /**
     * 操作类型 1 未审核 2 已审核 3 驳回  默认值1
     */
    private Integer cardOpertype;

    /**
     * 车位数
     */
    private Integer plotCount;

    /**
     * 购买数量
     */
    private Integer count;

    /**
     * 支付金额
     */
    private BigDecimal payMoney;

    /**
     * 支付方式(0 现金，1 银行卡 2：微信 3：支付宝)
     */
    private Integer payMethod;
    private String tradeNo;
    /**
     * 附件信息
     */
    private String attachment;

    /**
     * 退卡金额
     */
    private BigDecimal refund;

    /**
     * 月卡有效开始日期
     */
    private Date startTime;

    /**
     * 月卡有效结束日期
     */
    private Date endTime;

    /**
     * 车主地址
     */
    private String mainAddress;

    /**
     * 支付渠道 1 云平台 2：App 3：公众号
     */
    private Integer payChannel;

    /**
     * 月卡额外天数
     */
    private String addDay;

    /**
     * 月卡额外收费
     */
    private BigDecimal addAmount;

    /**
     * 公众号、h5的续费操作人
     */
    private String renewAccount;

    /**
     * 操作人
     */
    private String operAccount;

    /**
     * 备注
     */
    private String remark;

    /**
     * 创建时间
     */
    @TableField(fill = FieldFill.INSERT)
    private Date createTime;

    /**
     * 操作时间
     */
    @TableField(fill = FieldFill.UPDATE)
    private Date updateTime;


}
