package com.icetech.fee.domain.entity.monthcar;

import java.io.Serializable;
import java.time.LocalDate;

import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableName;
import lombok.Data;
import lombok.experimental.Accessors;

@Data
@Accessors(chain = true)
@TableName("`ice_month_rel_space`")
public class MonthRelSpace implements Serializable {
    /**
     * 主键自增长id
     */
    @TableId(value = "`id`", type = IdType.AUTO)
    protected Long id;
    /**
     * 月卡id
     */
    @TableField("`month_id`")
    protected Long monthId;
    /**
     * 车位号
     */
    @TableField("`space_num`")
    protected String spaceNum;
    /**
     * 车场id
     */
    @TableField("`park_id`")
    protected Long parkId;
    /**
     * 车位有效开始日期
     */
    @TableField("`start_time`")
    protected LocalDate startTime;
    /**
     * 车位有效结束日期
     */
    @TableField("`end_time`")
    protected LocalDate endTime;
}
