package com.icetech.fee.domain.entity;

import lombok.Data;

import java.math.BigDecimal;
import java.util.Date;

/**
 * <p>
 * 机器人现金退费表
 * </p>
 *
 * @author fangct
 * @since 2019-08-12
 */
@Data
public class CashRefund {

    private static final long serialVersionUID = 1L;

    /**
     * 主键自增长id
     */
    private Integer id;

    /**
     * 车场id
     */
    private Long parkId;

    /**
     * 订单号
     */
    private String orderNum;

    /**
     * 车牌号
     */
    private String plateNum;

    /**
     * 通道名称
     */
    private String inandoutName;

    /**
     * 设备编号
     */
    private String deviceNo;

    /**
     * 实际收钞金额
     */
    private BigDecimal actualCash;

    /**
     * 收钞时间
     */
    private Date receiveTime;

    /**
     * 状态，0：未退费，1：已退费
     */
    private Boolean status;

    /**
     * 退费时间
     */
    private Date refundTime;

    /**
     * 操作人
     */
    private String operAccount;

    /**
     * 备注
     */
    private String remark;

    /**
     * 创建时间
     */
    private Date createTime;

    /**
     * 更新时间
     */
    private Date updateTime;


}
