/*
 * Decompiled with CFR 0.152.
 */
package com.icetech.basics.constants;

import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public enum ParkDeviceTypeEnum {
    SUPER_BOX(0, "\u8d85\u7ea7\u76d2\u5b50"),
    CAMERA(1, "\u6444\u50cf\u5934"),
    GATE(2, "\u9053\u95f8"),
    SCREEN(3, "\u663e\u793a\u5c4f"),
    INTERCOM(4, "\u8bed\u97f3\u5bf9\u8bb2\u673a"),
    SMART_ROBOT(5, "\u667a\u80fd\u673a\u5668\u4eba"),
    MONITOR_CAMERA(6, "\u76d1\u63a7\u76f8\u673a"),
    INTERCOM_COLUMN(7, "\u8bed\u97f3\u5bf9\u8bb2\u53cd\u626b\u8bbe\u5907"),
    SMART_TERMINAL(8, "\u667a\u80fd\u7ec8\u7aef"),
    HX_MONITOR(9, "\u534e\u590f\u901a\u9053\u76d1\u63a7\u76f8\u673a");

    final Integer type;
    final String desc;
    private static final Map<Integer, ParkDeviceTypeEnum> TYPE_MAP;

    public static ParkDeviceTypeEnum ofType(Integer type) {
        if (type == null) {
            return null;
        }
        return TYPE_MAP.get(type);
    }

    public static String getTypeDesc(int type) {
        ParkDeviceTypeEnum typeEnum = ParkDeviceTypeEnum.ofType(type);
        return typeEnum == null ? null : typeEnum.getDesc();
    }

    public Integer getType() {
        return this.type;
    }

    public String getDesc() {
        return this.desc;
    }

    private ParkDeviceTypeEnum(Integer type, String desc) {
        this.type = type;
        this.desc = desc;
    }

    static {
        TYPE_MAP = Stream.of(ParkDeviceTypeEnum.values()).collect(Collectors.toMap(ParkDeviceTypeEnum::getType, Function.identity()));
    }
}

