package com.icetech.basics.domain.entity.park;

import java.io.Serializable;
import java.util.Date;

import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableName;
import lombok.Getter;
import lombok.Setter;
import lombok.ToString;
import lombok.experimental.Accessors;

/**
 * 停车场分区
 */
@Getter
@Setter
@ToString
@Accessors(chain = true)
@TableName(value = "`ice_park_region`")
public class ParkRegion implements Serializable {
    private static final long serialVersionUID = 1L;

    /**
     * ID
     */
    @TableId(value = "`id`")
    protected Long id;
    /**
     * 区域编号
     */
    @TableField(value = "`region_code`")
    protected String regionCode;
    /**
     * 区域名称
     */
    @TableField(value = "`region_name`")
    protected String regionName;
    /**
     * 车场id
     */
    @TableField(value = "`park_id`")
    protected Long parkId;
    /**
     * 从属关系 0:顶级 非零ID为此表中自增ID选择项 默认为0
     */
    @TableField(value = "`father_relation_id`")
    protected Long fatherRelationId;
    /**
     * 区域泊位总数
     */
    @TableField(value = "`region_park`")
    protected Integer regionPark;
    /**
     * 当前区域剩余车位数
     */
    @TableField(value = "`free_park`")
    protected Integer freePark;
    /**
     * 当前区域实际剩余车位数，可能会出现负数
     */
    @TableField(value = "`real_free_park`")
    protected Integer realFreePark;
    /**
     * 是否有内区域类型 1：是 2：否 默认为2
     */
    @TableField(value = "`region_type`")
    protected Integer regionType;
    /**
     * 添加时间
     */
    @TableField(value = "`create_time`")
    protected Date createTime;
    /**
     * 添加人
     */
    @TableField(value = "`adder`")
    protected String adder;
    /**
     * 更新时间
     */
    @TableField(value = "`update_time`")
    protected Date updateTime;
    /**
     * 更新人
     */
    @TableField(value = "`update_user`")
    protected String updateUser;
    /**
     * 描述信息
     */
    @TableField(value = "`remark`")
    protected String remark;
    /**
     * 状态0=正常，1=删除 默认是0
     */
    @TableField(value = "`status`")
    protected Integer status;
    /**
     * 区域类型 0：正常(不嵌套) 1：全嵌套 2：半嵌套 默认为0
     */
    @TableField(value = "`position_type`")
    protected Integer positionType;
    /**
     * 默认区域类型 0：外区域 1：不是外区域
     */
    @TableField(value = "`default_name`")
    protected Integer defaultName;

    /**
     * 区域新能源车是否区分油电和纯电车辆的计费规则，0是不区分 1是区分，默认为0
     */
    @TableField(value = "`is_newenergy_diffbill`")
    private Integer isNewEnergyDiffBill;
    /**
     * 在车位满的情况下，是否禁止临时车入内，0：否 1：是， 默认为0
     */
    @TableField(value = "`is_full_forbidenter`")
    protected Integer isFullForbidenter;
    /**
     * 在车位满的情况下，是否禁止月卡车入内，0：否 1：是
     */
    @TableField(value = "`is_full_forbidmonthenter`")
    protected Integer isFullForbidMonthEnter;
    /**
     * 在车位满的情况下，是否禁止VIP车入内，0：否 1：是
     */
    @TableField(value = "`is_full_forbidvipenter`")
    protected Integer isFullForbidVIPEnter;
    /**
     * 在车位满的情况下，是否禁止预约车入内，0：否 1：是
     */
    @TableField(value = "`is_full_forbidreserventer`")
    protected Integer isFullForbidReservEnter;
    /**
     * 在车位满的情况下，是否禁止储值车入内，0：否 1：是
     */
    @TableField(value = "`is_full_forbidstoreenter`")
    protected Integer isFullForbidStoreEnter;
    /**
     * 剩余多少空车位时，禁止入场，is_full_ forbidenter为1时不能为空
     */
    @TableField(value = "`full_emptynum`")
    protected Integer fullEmptynum;
    /**
     * 在车位满的情况下，是否禁止黑名单车入内，0：否 1：是
     */
    @TableField(value = "`is_full_forbidblackenter`")
    private Integer isFullForbidblackenter;

    /**
     * 车场类型id，多个以逗号隔开
     */
    @TableField(value = "`vip_car_type_id`")
    private String vipCarTypeId;

    /**
     * 大场补订单时候使用
     */
    @TableField(exist = false)
    private String orderNum;
    /**
     * 父区域编号
     */
    @TableField(exist = false)
    private String parentCode;

    /**
     * 燃油车泊位数
     */
    @TableField(value = "`oil_car_space`")
    private Integer oilCarSpace;

    /**
     * 充电泊泊位数
     */
    @TableField(value = "`charge_car_space`")
    private Integer chargeCarSpace;

    /**
     * 燃油车泊位停满后,不可进场 0: 否; 1: 是
     */
    @TableField(value = "`oil_car_full_flag`")
    private Integer oilCarFullFlag;

    /**
     * 充电车泊位停满后,不可进场 0: 否; 1: 是
     */
    @TableField(value = "`charge_car_full_flag`")
    private Integer chargeCarFullFlag;
}
