package com.icetech.basics.domain.entity.park;

import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableName;
import com.icetech.basics.domain.entity.device.ParkDevice;
import lombok.Getter;
import lombok.Setter;
import lombok.ToString;

import java.io.Serializable;
import java.util.Date;
import java.util.List;

@Setter
@Getter
@ToString
@TableName(value = "`ice_park_inoutdevice`")
public class ParkInoutdevice implements Serializable {
    //道通控制卡协议
    private static final Integer CARD_TYPE_DAO_TONG = 4;
    private static final Integer DISPLAY_TYPE_LED = 1;
    private static final Integer DISPLAY_TYPE_LCD = 2;

    /** id */
    @TableId(value = "`id`")
    protected Long id;
    /** 停车场ID */
    @TableField(value = "`park_id`")
    protected Long parkId;
    /** 出入口编号 */
    @TableField(value = "`inandout_code`")
    protected String inandoutCode;
    /** 第三方出入口编码 */
    @TableField(value = "`third_inandout_code`")
    protected String thirdInandoutCode;
    /** 出入口名称 */
    @TableField(value = "`inandout_name`")
    protected String inandoutName;
    /** 出入口类型，1入口 2出口 */
    @TableField(value = "`inandout_type`")
    protected Integer inandoutType;
    /** 通道图片 */
    @TableField(value = "`image`")
    protected String image;
    /** 状态 0正常 1冻结 */
    @TableField(value = "`status`")
    protected Integer status;
    /** 添加时间 */
    @TableField(value = "`create_time`")
    protected Date createTime;
    /** 添加人 */
    @TableField(value = "`adder`")
    protected String adder;
    /** 更新时间 */
    @TableField(value = "`update_time`")
    protected Date updateTime;
    /** 更新人 */
    @TableField(value = "`update_user`")
    protected String updateUser;
    /** 是否允许临时车进出 0:不允许  1：允许 默认1 */
    @TableField(value = "`is_allow_tempcarrun`")
    protected Integer isAllowTempcarrun;
    /** 是否允许无牌车扫码进出 0:不允许  1：允许 默认1 */
    @TableField(value = "`is_allow_nocardrun`")
    protected Integer isAllowNocardrun;
    /** 黄牌车是否允许进 0:不开启  1：开启 默认1 */
    @TableField(value = "`is_allow_yellowcarrun`")
    protected Integer isAllowYellowcarrun;
    /** 是否开启模糊识别 0:不开启  1：开启 默认0 */
    @TableField(value = "`is_open_vaguetype`")
    protected Integer isOpenVaguetype;
    /** 缓存时效，单位秒，默认为600秒； */
    @TableField(value = "`cache_expires`")
    protected Integer cacheExpires;
    /** 模糊模式 0：去汉字 1：去汉字1位 2：去汉字2位 */
    @TableField(value = "`vaguetype`")
    protected Integer vaguetype;
    /** 是否开启二维码扫码进出0：不允许，1：允许 默认0 此标识不再使用 */
    @TableField(value = "`is_open_qrcodetype`")
    protected Integer isOpenQrcodetype;
    /** 是否允许新能源车辆进出 0：不允许 1：允许 默认1 */
    @TableField(value = "`is_allow_newenergycarrun`")
    protected Integer isAllowNewenergycarrun;
    /** 是否允许预约车进出0：不允许，1：允许 */
    @TableField(value = "`is_allow_visit_car`")
    protected Integer isAllowVisitCar;
    /** 是否允月卡车车进出0：不允许，1：允许 */
    @TableField(value = "`is_allow_month_car`")
    protected Integer isAllowMonthCar;
    /** 是否允许过期月卡车进出0：不允许，1：允许 */
    @TableField(value = "`is_allow_overtime_car`")
    protected Integer isAllowOvertimeCar;
    /** 过期天数 */
    @TableField(value = "`over_time_day`")
    protected Integer overTimeDay;
    /** 过期卡是否按月卡处理0：否，1：是 */
    @TableField(value = "`overtime_monthly_card`")
    protected Integer overTimeMonthlyCard;
    /** 是否允许黑名单车进出0：不允许，1：允许 */
    @TableField(value = "`is_allow_back_car`")
    protected Integer isAllowBackCar;
    /** 是否允许Vip车进出0：不允许，1：允许 */
    @TableField(value = "`is_allow_vip_car`")
    protected Integer isAllowVipCar;
    /** 车场类型id，多个以逗号隔开 */
    @TableField(value = "`vip_car_type_id`")
    protected String vipCarTypeId;
    /** 是否允许多位多车月卡车进出1=是 0=否 */
    @TableField(value = "`is_allow_abcar`")
    protected Integer isAllowAbcar;
    /** 是否收费 1=是 0=否 */
    @TableField(value = "`is_fee`")
    protected Integer isFee;
    /** 是否是主通道 1=是 0=否 */
    @TableField(value = "`is_master`")
    protected Integer isMaster;
    /** 区域id */
    @TableField(value = "`region_id`")
    protected Long regionId;
    /** 是否允许蓝牌车进出 0:不允许  1：允许 默认1 */
    @TableField(value = "`is_allow_bluerun`")
    protected Integer isAllowBluerun;
    /** 是否允许储值卡车进入 0:不允许  1：允许 默认1 */
    @TableField(value = "`is_allow_stored_car`")
    protected Integer isAllowStoredCar;
    /** 显示终端类型，1：LED，2：LCD */
    @TableField(value = "`display_terminal`")
    protected Integer displayTerminal;
    /** 控制卡型号 18：方控 19：科发 27：瑞泰科 */
    @TableField(value = "`ledcard_type`")
    protected Integer ledcardType;
    /** 是否有TTS 0无,1有 */
    @TableField(value = "`tts_type`")
    protected Integer ttsType;
    /** 放行时间段类型，1：全天放行，2：分时段放行 */
    @TableField(value = "`range_type`")
    protected Integer rangeType;
    /** 区分工作日和非工作日标识，0：不区分，1：区分 */
    @TableField(value = "`diff_work_day`")
    protected Integer diffWorkDay;
    /**是否启用穿行限制(海大定制)  0表示不启用 1表示启用,默认为0**/
    @TableField(value = "`is_support_tralrestrictions`")
    protected Integer isSupportTralrestrictions;
    /**出口场通道对应享受免费时长的入口通道编号(海大配置)**/
    @TableField(value = "`enjoy_freetime_exitwaycodes`")
    protected String enjoyFreetimeExitwaycodes;

    /**
     * 车场通道编辑设备列表
     *
     */
    @TableField(exist = false)
    private List<ParkDevice> devices;
    @TableField(exist = false)
    private String parkCode;

    public Integer getLedLcdSource() {
        if (displayTerminal == null) {
            return null;
        }
        //通道LCD按LED存储的
        if (DISPLAY_TYPE_LCD.equals(displayTerminal) && CARD_TYPE_DAO_TONG.equals(ledcardType)) {
            return DISPLAY_TYPE_LED;
        } else {
            return displayTerminal;
        }
    }
}
