package com.icetech.basics.domain.entity.park;

import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableName;
import lombok.Getter;
import lombok.Setter;
import lombok.ToString;
import lombok.experimental.Accessors;

import java.io.Serializable;
import java.math.BigDecimal;
import java.util.Date;

/**
 * 停车场系统配置表
 */
@Getter
@Setter
@ToString
@Accessors(chain = true)
@TableName(value = "`ice_park_config`")
public class ParkConfig implements Serializable {
    private static final long serialVersionUID = 1L;

    /**
     * id (主健自增)
     */
    @TableId(value = "`id`")
    protected Long id;
    /**
     * 车场id
     */
    @TableField(value = "`park_id`")
    protected Long parkId;
    /**
     * 是否同步数据（0不同步1同步；默认0）
     */
    @TableField(value = "`is_sync`")
    protected Integer isSync;
    /**
     * 计费精度 0：分钟，1：秒 默认0
     */
    @TableField(value = "`bill_precision`")
    protected Integer billPrecision;
    /**
     * 军警车是否免费停车 0：不免费 1：免费  默认1
     */
    @TableField(value = "`isfree_specialcar`")
    protected Integer isfreeSpecialcar;
    /**
     * 是否支持AB车管理 0：不支持 1：支持 默认0
     */
    @TableField(value = "`issup_abmanage`")
    protected Integer issupAbmanage;
    /**
     * AB车场内切换**时间不收费，单位分钟
     */
    @TableField(value = "`switch_tm`")
    protected Integer switchTm;
    /**
     * 支持多车位管理超时处理规则1，B车计费结束时间按A车出场时间收费 2，B车计费结束时间按B车出场时间收费  默认为1
     */
    @TableField(value = "`switch_type`")
    protected Integer switchType;
    /**
     * 免费时间内是否自动抬杆 0：不自动  1：自动 默认为1
     */
    @TableField(value = "`isrelease_freetm`")
    protected Integer isreleaseFreetm;
    /**
     * 是否上报车辆图片 0：不上报 1：上报 默认为1
     */
    @TableField(value = "`isupimage`")
    protected Integer isupimage;
    /**
     * 是否支持电子支付 0：不支持 1：支持 默认为1
     */
    @TableField(value = "`is_epayment`")
    protected Integer isEpayment;
    /**
     * 聚合支付支付类型 微信/支付宝：WX_ALI_PAY 民生银行：CMBC_PAY  建设银行：CCB_PAY 农行：ABC_PAY  云纵: YZ_PAY 阿里平台支付: PARKING_PAY
     */
    @TableField(value = "`epayment`")
    protected String ePayment;
    /**
     * 是否支持无感支付 0：不支持 1：支持 默认为1
     */
    @TableField(value = "`is_nosenpayment`")
    protected Integer isNosenpayment;
    /**
     * 无感支付支付类型  银联无感支付：NO_SEN_UNION_PAY  建行无感支付：NO_SEN_CCB_PAY 农行无感支付：NO_SEN_ABC_PAY
     */
    @TableField(value = "`nosenpayment`")
    protected String noSenPayment;
    /**
     * 更新时间
     */
    @TableField(value = "`update_time`")
    protected Date updateTime;
    /**
     * 更新人
     */
    @TableField(value = "`update_user`")
    protected String updateUser;
    /**
     * 缴费后离场预留免费时长(单位分钟)
     */
    @TableField(value = "`isfree_afterpay`")
    protected Integer isfreeAfterpay;
    /**
     * 数据采集方式（相机直连、车场收费系统直连）:1端云;2端网云;3纯云
     */
    @TableField(value = "`data_collection`")
    protected Integer dataCollection;
    /**
     * 云计费（支持、不支持）
     */
    @TableField(value = "`cloud_charge`")
    protected Integer cloudCharge;
    /**
     * 开电子发票1是2否 默认为2
     */
    @TableField(value = "`is_invoice`")
    protected Integer isInvoice;
    /**
     * 免费时长是否计入停车费用1：是 2：否 默认为2
     */
    @TableField(value = "`freetime_status`")
    protected Integer freetimeStatus;
    /**
     * 是否补时 1是2否 默认为1
     */
    @TableField(value = "`is_filltime`")
    protected Integer isFilltime;
    /**
     * 超时计费起始时间1末次缴费时间 2车辆入场时间 默认为1
     */
    @TableField(value = "`overtime_bill_type`")
    protected Integer overtimeBillType;
    /**
     * 是否允许二次使用免费时长 1不允许2允许 默认为1
     */
    @TableField(value = "`isallowfreetmonce`")
    protected Integer isallowfreetmonce;
    /**
     * 收费是否抹零头1是2否 默认为1
     */
    @TableField(value = "`isnotgetsmallchange`")
    protected Integer isnotgetsmallchange;
    /**
     * 出场查无入场记录、支持固定收费1是2否  默认为2
     */
    @TableField(value = "`isfixedfees`")
    protected Integer isfixedfees;
    /**
     * 固定费用（单位元）
     */
    @TableField(value = "`fixedfeevalue`")
    protected Integer fixedfeevalue;
    /**
     * 大型车固定费用（单位元）
     */
    @TableField(value = "`fixed_fee_value_big`")
    protected Integer fixedFeeValueBig;
    /**
     * 计费规则版本编号（详见版本信息表定义)，默认为0
     */
    @TableField(value = "`charge_version_num`")
    protected Integer chargeVersionNum;
    /**
     * 是否允许无牌车重复入场，0：否 1：是， 默认为0
     */
    @TableField(value = "`is_noplate_repeatenter`")
    protected Integer isNoplateRepeatenter;
    /**
     * 在车位满的情况下，是否禁止临时车入内，0：否 1：是， 默认为0
     */
    @Deprecated
    @TableField(value = "`is_full_forbidenter`")
    protected Integer isFullForbidenter;
    /**
     * 在车位满的情况下，是否禁止月卡车入内，0：否 1：是
     */
    @Deprecated
    @TableField(value = "`is_full_forbidmonthenter`")
    protected Integer isFullForbidMonthEnter;
    /**
     * 在车位满的情况下，是否禁止VIP车入内，0：否 1：是
     */
    @Deprecated
    @TableField(value = "`is_full_forbidvipenter`")
    protected Integer isFullForbidVIPEnter;
    /**
     * 在车位满的情况下，是否禁止预约车入内，0：否 1：是
     */
    @Deprecated
    @TableField(value = "`is_full_forbidreserventer`")
    protected Integer isFullForbidReservEnter;
    /**
     * 在车位满的情况下，是否禁止储值车入内，0：否 1：是
     */
    @Deprecated
    @TableField(value = "`is_full_forbidstoreenter`")
    protected Integer isFullForbidStoreEnter;
    /**
     * 剩余多少空车位时，禁止入场，is_full_ forbidenter为1时不能为空
     */
    @Deprecated
    @TableField(value = "`full_emptynum`")
    protected Integer fullEmptynum;
    /**
     * 货币单位
     */
    @TableField(value = "`moneyunit_type`")
    protected String moneyunitType;
    /**
     * 新增月卡车是否计入总车位数1是 2 否 默认是2
     */
    @TableField(value = "`is_cardcount`")
    protected Integer isCardcount;
    /**
     * 车辆出入口停留多长时间监控坐席提醒
     */
    @TableField(value = "`carenex_timelong`")
    protected Integer carenexTimelong;
    /**
     * 滞留上报方式 1：一次，2：多次
     */
    @TableField(value = "`retention_alarm_method`")
    protected Integer retentionAlarmMethod;
    /**
     * 滞留重复报警间隔时间，范围在5到600；滞留报警方式为多次时，此值有效
     */
    @TableField(value = "`retention_interval_time`")
    protected Integer retentionIntervalTime;
    /**
     * 滞留车辆取消时间单位分钟
     */
    @TableField(value = "`retention_cancel_time`")
    protected Integer retentionCancelTime;
    /**
     * 是否特殊车场（存在进出共用一个通道的车场）0不是，1是 默认是0
     */
    @TableField(value = "`is_special_park`")
    protected Integer isSpecialPark;
    /**
     * 如果是特殊车场配置入场到出场最小时间值，以秒为单位，默认值是0，如果车辆出场时总停车时长小于x秒出场不进行任何处理
     */
    @TableField(value = "`enex_min_time`")
    protected Integer enexMinTime;
    /**
     * 如果是特殊车场配置出场到入场最小时间值，以秒为单位，默认值是0，如果车辆入场时上次出场时间至当前时间时间差小于x秒入场不进行任何处理
     */
    @TableField(value = "`exen_min_time`")
    protected Integer exenMinTime;
    /**
     * 显示终端类型，1：LED，2：LCD
     * @deprecated 变更为 {@link ParkInoutdevice#displayTerminal}
     */
    @Deprecated
    @TableField(value = "`display_terminal`")
    protected Integer displayTerminal;
    /**
     * 控制卡型号 18：方控 19：科发 27：瑞泰科
     * @deprecated 变更为 {@link ParkInoutdevice#ledcardType}
     */
    @Deprecated
    @TableField(value = "`ledcard_type`")
    protected Integer ledcardType;
    /**
     * 是否有TTS 0无,1有
     * @deprecated 变更为 {@link ParkInoutdevice#ttsType}
     */
    @Deprecated
    @TableField(value = "`tts_type`")
    protected Integer ttsType;
    /**
     * 双摄相机延时等待时长(毫秒),区间100-5000
     */
    @TableField(value = "`dualcamera_time`")
    protected Integer dualcameraTime;
    /**
     * 双相机进出时间间隔限制时长（毫秒）
     */
    @TableField(value = "`dualcamera_enextime`")
    protected Integer dualcameraEnextime;
    /**
     * 红包发放模式，1：自有账户，2：平台账户
     */
    @TableField(value = "`redpack_model`")
    protected Integer redpackModel;
    /**
     * 支持公众号访客预约 0否 1是
     */
    @TableField(value = "`is_visit`")
    protected Integer isVisit;
    /**
     * 访客车辆是否收费 0否 1是
     */
    @TableField(value = "`visit_ischarge`")
    protected Integer visitIscharge;
    /**
     * 新能源车辆免收首个2小时停车费（0：否，1：是，默认0）
     */
    @TableField(value = "`is_newenergy_charge`")
    protected Integer isNewenergyCharge;
    /**
     * 入口缴费标识 0不启用 1启用,默认0
     */
    @TableField(value = "`entry_pay_flag`")
    private Integer entryPayFlag;
    /**
     * 无牌车扫码校验：0：不允许（关闭） 1：允许（开启）默认1
     */
    @TableField(value = "`is_nocard_check`")
    private Integer isNocardCheck;

    /**
     * 过期expireMcDays天是否按月卡车处理,1是0否，默认为0
     */
    @TableField(value = "`is_expire_mc`")
    private Integer isExpireMc;
    /**
     * 过期X天按月卡处理，isExpireMc为是时必填
     */
    @TableField(value = "`expire_mc_days`")
    protected Integer expireMcDays;

    /**
     * 月卡过期over_time_day天是否可进，0：不允许，1：允许
     */
    @TableField(value = "`is_allow_overtime_car`")
    private Integer isAllowOvertimeCar;

    /**
     * 月卡过期X天
     */
    @TableField(value = "`over_time_day`")
    private Integer overTimeDay;

    /**
     * 在车位满的情况下，是否禁止黑名单车入内，0：否 1：是
     */
    @Deprecated
    @TableField(value = "`is_full_forbidblackenter`")
    private Integer isFullForbidblackenter;

    /**
     * 车场类型id，多个以逗号隔开
     */
    @Deprecated
    @TableField(value = "`vip_car_type_id`")
    private String vipCarTypeId;
    /**
     * 全免车辆重复入场，0：不允许，1：允许
     */
    @TableField(value = "`free_car_reenter`")
    private Integer freeCarReenter;

    /**
     * 访客预约限制次数 默认为0
     */
    @TableField(value = "`visit_inout_num`")
    private Integer visitInoutNum;
    /**
     * 空车位计算方式
     * 1-进出场加减
     * 2-泊位总数减在场车辆
     */
    @TableField(value = "`calc_space_method`")
    private Integer calcSpaceMethod;
    /**
     * 删除/修改离场, 余位是否更新(0/1)
     */
    @TableField(value = "`del_order_calc_space_flag`")
    private Integer delOrderCalcSpaceFlag;

    /**
     * 公众号访客车辆审核 1人工审核2自动审核 默认 2
     */
    @TableField(value = "`is_auto`")
    private Integer isAuto;

    /**
     * 月卡续费自动审核标识:0人工审核;1自动审核;默认1
     */
    @TableField(value = "`auto_renew_month_card_flag`")
    private Integer autoRenewMonthCardFlag;

    /**
     * 开启车牌号过滤 1 车场 2 道口
     */
    @TableField(value = "`plate_filter_type`")
    private Integer plateFilterType;

    /**
     * 过滤时间 秒
     */
    @TableField(value = "`filter_time`")
    private Integer filterTime;
    /**
     * 停车费X天内的可以开发票
     */
    @TableField(value = "`parking_invoice_days`")
    private Integer parkingInvoiceDays;
    /**
     * 月卡续费X天内的可以开发票
     */
    @TableField(value = "`monthcard_invoice_days`")
    private Integer monthcardInvoiceDays;
    /**
     * 场内办月卡收费方式，1：收取办月卡前时间段费用，2：全部停车时长免费
     */
    @TableField(value = "`inpark_renew_type`")
    private Integer inparkRenewType;
    /**
     * 过期月卡场内续费有临时车空档期收费方式，1：收取临时车空档期费用，2：全部停车时长免费
     */
    @TableField(value = "`timeout_renew_type`")
    private Integer timeoutRenewType;
    /**
     * 公众号月卡续费开始时间要求，1：可选择开始时间，2：连续续费
     */
    @TableField(value = "`renew_starttime_type`")
    private Integer renewStarttimeType;
    /**
     * 公众号过期X天内可续费，最大365
     */
    @TableField(value = "`renew_limit_day`")
    private Integer renewLimitDay;
    /**
     * 公众号续费最大可购买月数
     */
    @TableField(value = "`card_limit_month`")
    private Integer cardLimitMonth;

    /**
     * 无入场权限的车辆，相机识别后记录在场，道闸不起杆 0:关闭 1:开启 默认0
     */
    @TableField(value = "`denied_add_order`")
    private Integer deniedAddOrder;

    /**
     * 重复入场行为超过X次,再次进场后，将车辆加入黑名单
     */
    @TableField(value = "`reenter_black_time`")
    private Integer reenterBlackTime;

    /**
     * 欠费车辆入口补缴开关 0:关闭 1:开启 默认0
     */
    @TableField(value = "`enterpay_type`")
    private Integer enterpayType;

    /**
     * 入场前需补缴N（1-30）天有欠费订单
     */
    @TableField(value = "`enterpay_range_day`")
    private Integer enterpayRangeDay;

    /**
     * 车辆出口缴费，找不到车辆入场信息 处理方式 1,人工处理 2,匹配该车辆上一次入场记录计费 3,固定收费
     */
    @TableField(value = "`noenter_handle_type`")
    private Integer noenterHandleType;

    /**
     * 匹配上一次入场记录的时间范围X（1天内,2天内,3天内，7-30天）的入场记录
     */
    @TableField(value = "`rel_lastenter_range`")
    private Integer relLastenterRange;

    /**
     * 欠费出口补缴开关 0:关闭 1:开启 默认0
     */
    @TableField(value = "`exitpay_type`")
    private Integer exitpayType;

    /**
     * 本次费用+ X（1-30）天内的欠费订单合并支付
     */
    @TableField(value = "`exitpay_range_day`")
    private Integer exitpayRangeDay;

    /**
     * 开启虚假车牌功能，1：开启，0：关闭
     */
    @TableField(value = "`enable_sham_plate`")
    private Integer enableShamPlate;

    /**
     * 虚假车牌处理方式，1：报警，2：过滤
     */
    @TableField(value = "`sham_plate_method`")
    private Integer shamPlateMethod;
    /**
     * 开启重复入场加入黑名单开关，1：开启，0：关闭
     */
    @TableField(value = "`enable_reenter_black`")
    private Integer enableReenterBlack;
    /**
     *
     */
    @TableField(value = "`notpay_tag_days`")
    private Integer notpayTagDays;

    /**
     * 新能源首停优惠时长(分钟) 0代表不优惠;
     */
    @TableField(value = "`new_energy_discount_minutes`")
    private Integer newEnergyDiscountMinutes;
    /**
     * 公务车免收费校验开关：0：关闭 1：开启 默认0
     */
    @TableField(value = "`free_official_cars`")
    private Integer freeOfficialCars;

    /**
     * 新能源车辆免收首个2小时停车费(0:否;1:是;默认0)
     */
    @TableField(value = "`new_energy_charge_flag`")
    private Integer newEnergyChargeFlag;

    /**
     * 新能源首停优惠时长(分钟)-济南使用
     */
    @TableField(value = "`new_energy_vehicles_discount_minutes`")
    private Integer newEnergyVehiclesDiscountMinutes;

    /**
     * 大额订单阈值
     */
    @TableField(value = "order_big_amt")
    private BigDecimal orderBigAmt;

    /**
     * 是否开启大额订单追缴 0：不开启，1：开启
     */
    @TableField(value = "`is_order_big_amt`")
    private Integer isOrderBigAmt;

    /** 是否启用追缴功能 0/1 */
    protected Integer isEnableRecovery;
    /** 是否只收取本车场欠费 0/1 */
    protected Integer onlyRecoverySelf;
    /** 是否允许收取路侧欠费 0/1 */
    protected Integer allowRecoveryRoad;

    public Integer getIsfreeAfterpay(Integer defaultValue) {
        if (this.isfreeAfterpay == null) {
            return defaultValue;
        }
        return isfreeAfterpay;
    }

    public int getCalcSpaceMethod(Integer defaultValue) {
        return calcSpaceMethod == null ? defaultValue : calcSpaceMethod;
    }

    public int getDelOrderCalcSpaceFlag(Integer defaultValue) {
        return delOrderCalcSpaceFlag == null ? defaultValue : delOrderCalcSpaceFlag;
    }
}
