package com.icetech.basics.domain.entity.park;

import java.io.Serializable;

import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableName;
import lombok.Data;

@Data
@TableName(value = "`ice_park_chargeconfig`")
public class ParkChargeconfig implements Serializable {
    /** ID (主健自增) */
    @TableId(value = "`id`")
    protected Integer id;
    /** 车场id */
    @TableField(value = "`park_id`")
    protected Long parkId;
    /** 计费规则编号 时间+随机数小于16位 */
    @TableField(value = "`billtypecode`")
    protected String billtypecode;
    /** 计费类型1.通用自然天  2.白天夜间收费 3.24小时计费 */
    @TableField(value = "`billtype`")
    protected Integer billtype;
    /** 是否默认计费，1默认，0，非默认，默认0 */
    @TableField(value = "`default_charge`")
    protected Integer defaultCharge;
    /** 计费规则名称 */
    @TableField(value = "`billtypename`")
    protected String billtypename;
    /** 车牌类型:0是默认计费规则，对应的是其它车牌类型，1是新能源车牌计费规则，2 vip车辆计费柜子3 蓝牌车计费规则4 黄牌车计费规则5收费月卡车计费规则 默认是0，计费时需要 */
    @TableField(value = "`license_plate_type`")
    protected Integer licensePlateType;
    /** 区域id */
    @TableField(value = "`region_id`")
    protected Integer regionId;
    /** 状态 0 正常，1删除 默认为0 */
    @TableField(value = "`status`")
    protected Integer status;

    public enum BilltypeEnum {
        通用自然天(1), 白天夜间收费(2), 二十四小时计费(3);
        public int type;

        private BilltypeEnum(int type) {
            this.type = type;
        }
    }
}
