package com.icetech.basics.domain.entity.park;

import lombok.Data;

import java.io.Serializable;
import java.util.Date;

/**
 *  开关闸表
 *
 *  Created by xuxueli on '2019-05-13 09:58:28'.
 */
@Data
public class Opening implements Serializable {
    private static final long serialVersionUID = 42L;

    /**
     * id
     */
    private Integer id;

    /**
     * 类型（1开闸，2关闸）
     */
    private int switchType;

    /**
     * 车场id
     */
    private int parkId;

    /**
     * 通道id
     */
    private String channelId;

    /**
     * 设备编号
     */
    private String deviceNo;

    /**
     * 序列ID
     */
    private String sequenceid;

    /**
     * 是否下发（0未下发，1已下发 2：超时 默认0）
     */
    private int sendType;

    /**
     * 状态（1成功2失败默认0
     */
    private int status;

    /**
     * 发送次数
     */
    private int sendNum;

    /**
     * 操作人账号
     */
    private String operAccount;

    /**
     * 如执行错误，此重点描述错误原因
     */
    private String remark;

    /**
     * 执行时间
     */
    private Date issuedTm;

    /**
     * 回复时间
     */
    private Date replyTm;

    /**
     * 请求时间
     */
    private Date createTime;

    /**
     * 开关闸来源 1：岗亭开闸 2：远程开关闸（包括中控与云平台指令）
     */
    private int sourcegate;

    /**
     * 位置
     */
    private String gatepos;

    /**
     * 图片
     */
    private String gatephoto;

    /**
     * 车牌号
     */
    private String plateNum;

    /**
     * 订单号
     */
    private String orderNum;

    /**
     * 开闸原因1未找到入场记录  2缴费后未抬杆  3非机动车
     */
    private int reason;

    /**
     * 开闸类型（1:进场;2:出场）
     */
    private int gateType;

}
