package com.icetech.basics.domain.entity.park;

import java.io.Serializable;
import java.util.Date;

import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableName;
import lombok.Getter;
import lombok.Setter;
import lombok.ToString;
import lombok.experimental.Accessors;

/**
 * 停车场表
 */
@Getter
@Setter
@ToString
@Accessors(chain = true)
@TableName(value = "`ice_park`")
public class BasePark implements Serializable {
    /** 主键自增长id */
    @TableId(value = "`id`")
    protected Long id;
    /** 停车场编号 */
    @TableField(value = "`parkcode`")
    protected String parkCode;
    /** 名称 */
    @TableField(value = "`park_name`")
    protected String parkName;
    /** 所属机构 */
    @TableField(value = "`institution_id`")
    protected Integer institutionId;
    /** 所属省份 */
    @TableField(value = "`province_id`")
    protected Integer provinceId;
    /** 所属城市 */
    @TableField(value = "`city_area_id`")
    protected Integer cityAreaId;
    /** 所属区域 */
    @TableField(value = "`district_id`")
    protected Integer districtId;
    /** 联系方式 */
    @TableField(value = "`phone`")
    protected String phone;
    /** 停车场地址 */
    @TableField(value = "`address`")
    protected String address;
    /** 出口数量 */
    @TableField(value = "`total_exit`")
    protected Integer totalExit;
    /** 入口数量 */
    @TableField(value = "`total_enter`")
    protected Integer totalEnter;
    /** 泊位总数 */
    @TableField(value = "`total_park`")
    protected Integer totalPark;
    /** 长租车位数 */
    @TableField(value = "`total_fixedspaces`")
    protected Integer totalFixedspaces;
    /** 车场类型（0:室内、1：室外、2：室内+室外、3：占道 默认：0 */
    @TableField(value = "`park_type`")
    protected Integer parkType;
    /** 车场客户端类型（1车牌识别 */
    @TableField(value = "`park_client_type`")
    protected Integer parkClientType;
    /** 场中场切换免费时长 分钟 */
    @TableField(value = "`switch_fee_time`")
    protected Integer switchFeeTime;
    /** 运营状态（1正常、0暂停） */
    @TableField(value = "`status`")
    protected Integer status;
    /** 资产类型(1产权、2管理权、3经营权默认0) */
    @TableField(value = "`asset_type`")
    protected Integer assetType;
    /** 合作方式(1自营、2合作、3加盟默认0) */
    @TableField(value = "`cooperate_type`")
    protected Integer cooperateType;
    /** 停车场属性 0：其他 1：商超 2：商务写字楼 3：公共场馆 4 星级酒店 5：住宅 6：医院 7：学校 8：交通枢纽 9：商业综合体 10产业园 11路侧 */
    @TableField(value = "`park_property`")
    protected Integer parkProperty;
    /** 是否存在场中场(0否，1是默认0) */
    @TableField(value = "`is_interior`")
    protected Integer isInterior;
    /** 纬度 */
    @TableField(value = "`lat`")
    protected String lat;
    /** 经度 */
    @TableField(value = "`lng`")
    protected String lng;
    /** 密钥 */
    @TableField(value = "`key`")
    protected String key;
    /** 添加时间 */
    @TableField(value = "`create_time`")
    protected Date createTime;
    /** 添加人 */
    @TableField(value = "`adder`")
    protected String adder;
    /** 更新时间 */
    @TableField(value = "`update_time`")
    protected Date updateTime;
    /** 更新人 */
    @TableField(value = "`update_user`")
    protected String updateUser;
    /** 车场营业执照 */
    @TableField(value = "`park_business_license`")
    protected String parkBusinessLicense;
    /** 车场图片 */
    @TableField(value = "`park_imgs`")
    protected String parkImgs;
    /** 紧急联系电话 */
    @TableField(value = "`telphone`")
    protected String telphone;
    /** 场中场嵌套类型，0：正常(不嵌套) 1：全嵌套 2：半嵌套 3：平行区域 */
    @TableField(value = "`nest_type`")
    protected Integer nestType;
    /**
     * 进件状态 1.未开通 3.被驳回4.已开通
     */
    @TableField(value = "`input_status`")
    protected Integer inputStatus;
    /**
     * 充电泊位数
     */
    @TableField(value = "`charge_car_space`")
    protected Integer chargeCarSpace;
}
