package com.icetech.basics.domain.entity.device;

import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableName;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.NoArgsConstructor;

import java.io.Serializable;
import java.util.Date;

@Data
@EqualsAndHashCode(callSuper = false)
@NoArgsConstructor
@TableName("ice_park_devrecord")
public class ParkDevrecord implements Serializable {
    private static final long serialVersionUID=1L;

    /**
     * iD (主健自增)
     */
    @TableId(value = "id", type = IdType.AUTO)
    private Integer id;
    /**
     * 设备编号
     */
    private String deviceCode;

    /**
     * 停车场ID
     */
    private Integer deviceId;

    /**
     * 故障原因
     */
    private String reason;

    /**
     * 设备状态,2离线3故障
     */
    private Integer status;

    /**
     * 故障时间
     */
    private Date wrongTime;

    /**
     * 解决时间
     */
    private Date solveTime;

    /**
     * 操作人
     */
    private String operAccount;

    /**
     * 备注
     */
    private String remark;
    /**
     * 车场名称
     */
    private String parkName;
    /**
     *设备类型
     */
    private String deviceType;
    /**
     *所属出入口名称
     */
    private String inandoutName;

    /**
     * 设备序列号
     */
    private String serialNumber;

    /**
     * 数据上报方式:1端云;2端网云;3纯云
     */
    @TableField(exist = false)
    private Integer dataCollection;

    /**
     * 车场id
     */
    @TableField(exist = false)
    private Long parkId;
}
