package com.icetech.basics.domain.entity.device;

import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableName;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.NoArgsConstructor;

import java.io.Serializable;
import java.util.Date;

@Data
@EqualsAndHashCode(callSuper = false)
@NoArgsConstructor
@TableName("`ice_park_device`")
public class ParkDevice implements Serializable {
    private static final long serialVersionUID=1L;
    /** id */
    @TableId(value = "`id`")
    protected Integer id;
    /** 停车场ID */
    @TableField(value = "`park_id`")
    protected Long parkId;
    /** 设备编号 */
    @TableField(value = "`device_no`")
    protected String deviceNo;
    /** 第三方设备编码 */
    @TableField(value = "`third_code`")
    protected String thirdCode;
    /** 设备类型 0：超级盒子 1：摄像头 2:道闸 3:显示屏 4:语音对讲机 5:智能机器人 6:监控相机 7:语音对讲反扫设备 8:智能终端 */
    @TableField(value = "`type`")
    protected Integer type;
    /** 出入口通道id(出入口表自增ID) */
    @TableField(value = "`channel_id`")
    protected Integer channelId;
    /** 相机型号1：V82, 2：V83 */
    @TableField(value = "`model_type`")
    protected Integer modelType;
    /** 相机序列号 */
    @TableField(value = "`serial_number`")
    protected String serialNumber;
    /** 端云相机协议版本号 */
    @TableField(value = "`protocol_ver`")
    protected String protocolVer;
    /** 端云相机协议类型，1：WS，2：阿里IOT */
    @TableField(value = "`protocol_type`")
    protected Integer protocolType;
    /** 设备型号 */
    @TableField(value = "`product_model`")
    protected String productModel;
    /** 固件版本号 */
    @TableField(value = "`firmware_version`")
    protected String firmwareVersion;
    /** 相机序列号图片 */
    @TableField(value = "`image_url`")
    protected String imageUrl;
    /** 设备IP */
    @TableField(value = "`ip`")
    protected String ip;
    /** 设备端口 */
    @TableField(value = "`port`")
    protected String port;
    /** 通讯方式 1:无线 2:有线3:wifi 4:相机485透传 */
    @TableField(value = "`call_methods`")
    protected Integer callMethods;
    /** 设备状态,0初始1在线2离线3故障 */
    @TableField(value = "`status`")
    protected Integer status;
    /** 删除标记，0：正常，1：删除 */
    @TableField(value = "`del_flag`")
    protected Integer delFlag;
    /** 上报或创建时间 */
    @TableField(value = "`create_time`")
    protected Date createTime;
    /** 更新时间 */
    @TableField(value = "`update_time`")
    protected Date updateTime;
    /** 添加人 */
    @TableField(value = "`adder`")
    protected String adder;
    /** 最后一次通讯时间 */
    @TableField(value = "`end_updatetime`")
    protected Date endUpdatetime;
    /** 通讯类型（0: TCP/IP，1：串口） */
    @TableField(value = "`linetype`")
    protected Integer linetype;
    /** 串口地址 */
    @TableField(value = "`serialaddr`")
    protected Integer serialaddr;
    /** 波特率（0：1200，1：2400，2：4800，3：9600，4：19200，5：38400，6：115200，默认2400）;  */
    @TableField(value = "`baudrate`")
    protected Integer baudrate;
    /** 监控相机视频地址 */
    @TableField(value = "`video_url`")
    protected String videoUrl;
    /** 是否双摄相机，1：是，0：否 */
    @TableField(value = "`is_dualcamera`")
    protected Integer isDualcamera;
    /** 是否主相机，0：否，1：是，一个通道只会有一个主相机 */
    @TableField(value = "`is_master`")
    protected Integer isMaster;
    /**  */
    @TableField(value = "`ver_code`")
    protected String verCode;
    /**  */
    @TableField(value = "`ezopen_id`")
    protected Integer ezopenId;
    /** 通讯协议是否自动切换 0:否  1：是 默认1 */
    @TableField(value = "`is_autoswitch_check`")
    protected Integer isAutoswitchCheck;
    /** 语音对讲设备厂商类型 1：云翌  2：笛虎 */
    @TableField(value = "`voicevendor_type`")
    protected Integer voicevendorType;
    /** 无线网络运营商，1:移动，2:电信，3：联通，99：未知 */
    @TableField(value = "`wireless_carrier`")
    protected Integer wirelessCarrier;
    /** 第几代无线网，例：5G、4G、3G、2G */
    @TableField(value = "`network`")
    protected String network;
    /** 对讲序列号 */
    @TableField(value = "`talkback_serial_number`")
    protected String talkbackSerialNumber;
    /** 支持新版本蓝牙，0：否，1：是 */
    @TableField(value = "`new_bluetooth`")
    protected Integer newBluetooth;

    /**
     * 网络连接方式，1:无线，2:有线
     */
    @TableField(exist = false)
    private Integer connectionMode;
    /**
     * 车场编号
     */
    @TableField(exist = false)
    private String parkCode;
    @TableField(exist = false)
    private Integer isVoiceLed;
    @TableField(exist = false)
    private Integer isParkGate;
}
