package com.icetech.basics.domain.entity.device;

import com.alibaba.fastjson2.annotation.JSONField;
import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableName;
import com.fasterxml.jackson.annotation.JsonFormat;
import com.icetech.common.utils.DateUtils;
import lombok.EqualsAndHashCode;
import lombok.Getter;
import lombok.NoArgsConstructor;
import lombok.Setter;
import lombok.ToString;

import java.io.Serializable;
import java.time.LocalDateTime;

@Getter
@Setter
@ToString
@EqualsAndHashCode(callSuper = false)
@NoArgsConstructor
@TableName("ice_heartbeat_offline")
public class HeartbeatOffline implements Serializable {
    private static final long serialVersionUID=1L;

    /**
     * iD (主健自增)
     */
    @TableId(value = "id", type = IdType.AUTO)
    private Long id;
    private Long parkId;
    private Long lastConnectionTime;
    private Long reconnectTime;
    private Long offTime;
    private String deviceNo;
    @com.alibaba.fastjson.annotation.JSONField(format = DateUtils.DEFAULT_DATETIME_PATTERN)
    @JSONField(format = DateUtils.DEFAULT_DATETIME_PATTERN)
    @JsonFormat(pattern = DateUtils.DEFAULT_DATETIME_PATTERN)
    private LocalDateTime createTime;

}
