package com.icetech.basics.domain.entity.charge;

import java.io.Serializable;
import java.util.Date;

import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableName;
import lombok.Data;

@Data
@TableName(value = "`ice_charge_naturalday`")
public class ChargeNaturalday implements Serializable {
    /** id */
    @TableId(value = "`id`")
    protected Integer id;
    /** 计费规则编号 时间+随机数小于16位 */
    @TableField(value = "`billtypecode`")
    protected String billtypecode;
    /** 计费规则名称 */
    @TableField(value = "`billtypename`")
    protected String billtypename;
    /** 车场id */
    @TableField(value = "`park_id`")
    protected Long parkId;
    /** 工作日计费方式 1：按次计费 2：按时计费 */
    @TableField(value = "`billmethod`")
    protected Integer billmethod;
    /** 非工作日计费方式 1：按次计费 2：按时计费 */
    @TableField(value = "`nowork_billmethod`")
    protected Integer noworkBillmethod;
    /** 是否区分工作日非工作日计费 1是 2否 默认为2 */
    @TableField(value = "`isspecialdaycharge`")
    protected Integer isspecialdaycharge;
    /** 时段类型 1：工作日 2：非工作日 */
    @TableField(value = "`specialdaytype`")
    protected Integer specialdaytype;
    /** 免费时长（分钟） */
    @TableField(value = "`freetime`")
    protected Integer freetime;
    /** 是否使用一天最大收费限额(一天) 0：禁用  1：启用 默认为0 */
    @TableField(value = "`daynightmaxfeeusing`")
    protected Integer daynightmaxfeeusing;
    /** 单天最高收费金额 元 */
    @TableField(value = "`daynightmaxfee`")
    protected Float daynightmaxfee;
    /** 状态（0：正常，1：删除，默认0） */
    @TableField(value = "`status`")
    protected Integer status;
    /** 备注 */
    @TableField(value = "`remark`")
    protected String remark;
    /** 添加人 */
    @TableField(value = "`adder`")
    protected String adder;
    /** 添加时间 */
    @TableField(value = "`addtime`")
    protected Date addtime;
    /** 最后修改人 */
    @TableField(value = "`update_user`")
    protected String updateUser;
    /** 更新时间 */
    @TableField(value = "`update_time`")
    protected Date updateTime;
    /** 大型车单天最高收费金额元 */
    @TableField(value = "`daynightmaxfee_big`")
    protected Float daynightmaxfeeBig;
    /** 是否区分大小型车计费（0：否，1：是） */
    @TableField(value = "`is_smallbigcar_set`")
    protected Integer isSmallbigcarSet;
    /** 最高收费类型  1=单天单次最高收费 2=单天最高收费 3=24小时最高收费 4=单次最高收费 */
    @TableField(value = "`maxfeetype`")
    protected Integer maxFeeType;
    /** 24小时统计方式 1=以24小时内的订单入场时间为准 2=以24小时之内的出场时间判断 */
    @TableField(value = "`counttype`")
    protected Integer countType;
    /** 免费时段每日最多使用次数, -1表示无限制 */
    @TableField(value = "`is_freetime_once`")
    protected Integer isFreetimeOnce;
}
