package com.icetech.basics.domain.entity;

import java.io.Serializable;

import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableName;
import com.icetech.basics.constants.RegionChargePlateTypeConsts;
import lombok.Data;

/**
 * ice_park_chargeconfig
 * @author
 */
@Data
@TableName("ice_region_chargeconfig")
public class RegionChargeconfig implements Serializable {
    /** ID */
    @TableId(value = "`id`")
    protected Integer id;
    /** 车场id */
    @TableField(value = "`park_id`")
    protected Long parkId;
    /** 区域ID */
    @TableField(value = "`region_id`")
    protected Integer regionId;
    /** 计费规则编号 时间+随机数小于16位 */
    @TableField(value = "`billtypecode`")
    protected String billtypecode;
    /** 计费类型1.通用自然天  2.白天夜间收费 3.24小时计费 */
    @TableField(value = "`billtype`")
    protected Integer billtype;
    /** 是否默认计费，1默认，0，非默认，默认1 */
    @TableField(value = "`default_charge`")
    protected Integer defaultCharge;
    /** <dl>
     * <dt>车牌类型</dt>
     * <dd>0 是区域的默认计费规则</dd>
     * <dd>1 是新能源车牌（不区分油电混合和纯电是所有新能源车计费规则，否则是油电混合计费规则）</dd>
     * <dd>2 vip车</dd>
     * <dd>3 蓝牌车</dd>
     * <dd>4 黄牌车</dd>
     * <dd>5 收费月卡车</dd>
     * <dd>6 储值卡车</dd>
     * <dd>7 新能源车纯电计费规则</dd>
     * <dd>8 错时月卡超出免费时段</dd>
     * <dd>9 节假日计费规则</dd>
     * <dd>10 新能源车节假日计费规则</dd>
     * </dl>
     * 默认是0 计费时需要
     * @see RegionChargePlateTypeConsts
     */
    @TableField(value = "`license_plate_type`")
    protected Integer licensePlateType;
    /** 0=正常 1=刪除 */
    @TableField(value = "`status`")
    protected Integer status;
    /**
     * 是否开启，0 关闭，1开启，仅月卡计费规则使用
     */
    @TableField(value = "`enabled`")
    protected Integer enabled;


    /** 是否启用节假日计费 默认0,0否，1是 */
    @TableField("holiday_type")
    protected Integer holidayType;
    /** 是否包含周六日,0不包含 1,包含 默认0 */
    @TableField("is_include_weekends")
    protected Integer isIncludeWeekends;
    /** 是否包含周六日,0不包含 1,包含 默认0 */
    @TableField("is_newenergy_include_weekends")
    protected Integer isNewenergyIncludeWeekends;
}
