package com.icetech.basics.domain.entity;

import com.baomidou.mybatisplus.annotation.TableName;
import com.baomidou.mybatisplus.annotation.IdType;
import java.util.Date;
import java.time.LocalDate;
import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.FieldFill;
import com.baomidou.mybatisplus.annotation.TableField;
import java.io.Serializable;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.NoArgsConstructor;

/**
 * 非工作日表
 * Copyright (c) Department of Research and Development/Beijing
 * All Rights Reserved
 *
 * @author fangct
 * @version 1.0 @date 2022-12-02
 */
@Data
@EqualsAndHashCode(callSuper = false)
@NoArgsConstructor
@TableName("ice_not_work_day")
public class NotWorkDay implements Serializable {

    private static final long serialVersionUID=1L;

    /**
     * 主键ID
     */
    @TableId(value = "id", type = IdType.AUTO)
    private Integer id;

    /**
     * 年月日
     */
    private LocalDate ymd;
    /** 日期类型 */
    private Integer dateType;

    /**
     * 添加时间
     */
    @TableField(fill = FieldFill.INSERT)
    private Date createTime;

    /** 日期类型-工作日 */
    public static final Integer DATE_TYPE_WORKDAY = 1;
    /** 日期类型-周末 */
    public static final Integer DATE_TYPE_WEEKEND = 2;
    /** 日期类型-节假日 */
    public static final Integer DATE_TYPE_HOLIDAY = 3;
    /** 日期类型-调休 */
    public static final Integer DATE_TYPE_SWAPDAY = 4;
}
