package com.icetech.basics.domain.entity;

import io.swagger.annotations.ApiModelProperty;
import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableName;
import lombok.Data;

import java.io.Serializable;

/**
 * <p>
 * 省份表
 * </p>
 *
 * @author zhang
 * @since 2021-05-28
 */
@Data
@TableName("ice_area_province")
public class AreaProvince implements Serializable {
    @TableId
    @ApiModelProperty(value = "系统分配id编码（provinceId 入参时使用）", required = true, example = "1", position = 1)
    private Integer id;
    /**
     * 省份代码
     */
    @ApiModelProperty(value = "省份代码", required = true, example = "10001", position = 2)
    private String code;
    /**
     * 省份名称
     */
    @ApiModelProperty(value = "省份名称", required = true, example = "吉林省", position = 3)
    private String name;
    /**
     * 省份简称
     */
    private String abbr;
}
