package com.icetech.basics.domain.entity;


import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.io.Serializable;

/**
 * <p>
 * 区域表
 * </p>
 *
 * @author fangct
 * @since 2021-05-28
 */
@Data
public class AreaDistrict implements Serializable {


    /**
     * id
     */
    @ApiModelProperty(value = "列表id编码（下级地区列表 upperId 入参时使用）", required = true, example = "1", position = 1)
    private Integer id;

    /**
     * 市id
     */
    @ApiModelProperty(value = "市id", required = true, example = "1", position = 2)
    private Integer cityId;

    /**
     * 名称
     */
    @ApiModelProperty(value = "地区级名称", required = true, example = "昌平区", position = 3)
    private String name;

    /**
     * 编号
     */
    @ApiModelProperty(value = "系统编号", required = true, example = "1000", position = 4)
    private String code;



}
