package com.icetech.basics.domain.entity;

import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.io.Serializable;

/**
 * <p>
 * 城市表
 * </p>
 *
 * @author wangzw
 * @since 2018-11-20
 */
@Data

public class AreaCity implements Serializable {

    private static final long serialVersionUID = 1L;

    @ApiModelProperty(value = "列表id编码（下级地区列表 upperId 入参时使用）", required = true, example = "1", position = 1)
    private Integer id;

    @ApiModelProperty(value = "省份id", required = true, example = "1", position = 2)
    private Integer provinceId;

    @ApiModelProperty(value = "城市级名称", required = true, example = "北京", position = 3)
    private String name;

    @ApiModelProperty(value = "系统编号", required = true, example = "100", position = 4)
    private String code;


}
